@echo off
set pathName=%~dp0
cd %pathName%
:startOver
set fileName=""
set response=""
set testName = "Backup"

cls
echo ___________________________
echo.
echo TEI Navigator Rename Utility
echo.
echo ___________________________
echo.
echo This utility takes a folder of Navigator portfolio files, copies them to a new folder and renames them in simplified form, suitable for use with the TEI Analysis Utility.
echo.
echo There are two steps in the process:
echo. 
echo 1. Choose the folder with the files to be copied, 
echo.
echo 2. Choose a folder in which the copies are to be placed.
echo.
echo ___________________________
echo.
pause
cls
echo. 
echo ___________________________
echo.
echo Step 1: Drag the folder to be copied onto this window and press enter...
echo.
echo ___________________________
echo.
set /p sourceFolder=""
(if not exist %sourceFolder% (echo Sorry - cannot find this folder. Try again? y/n) & (set /p response=""))
if %response%==n (Exit)
if %response%==y (GOTO startOver)
:csvOver
echo.
echo ___________________________
echo.
echo Step 2: Drag the destination folder...
echo.
echo ___________________________
echo.
set /p folderName=""
if not exist %folderName% (md %pathName%%folderName%)

    SETLOCAL ENABLEDELAYEDEXPANSION
FOR /r "%sourceFolder%" %%j IN (*.*) DO (

    SET fullname=%%j
    set newName=%%~nj
    set ext=%%~xj

echo.
REM echo !newName!
echo.
echo ___________________________
echo.

for /f "tokens=1,2,3,4,5 delims=_" %%a in ("!newName!") do (

set firstname=%%b&set surname=%%c
set realName=!firstname!_!surname!

set testName=%%d_%%e
set DATEST=!testName!_%DATE:~10,4%%DATE:~4,2%%DATE:~7,2%-%TIME:~0,2%%TIME:~3,2%%TIME:~6,2%
REM echo !DATEST!

if not exist %pathName%%folderName%\!DATEST! (md %pathName%%folderName%\!DATEST!)

echo.
REM echo !realName!
echo.
echo ___________________________
echo.
copy !fullname! %folderName% /y
copy !fullname! %pathName%%folderName%\!DATEST! /y

echo !realName!!ext!

cd %folderName%

if exist !realName!!ext! (

	del !realName!!ext!)
	)

 ren !newName!!ext! !realName!!ext!

cd !DATEST!
 ren !newName!!ext! !realName!!ext!
 cd %pathName%

)
)
 ENDLOCAL

