@echo off
set pathName=%~dp0
cd %pathName%
set testName="Backup"
cls
echo ___________________________
echo.
echo TEI Test Duplicator Utility
echo.
echo ___________________________
echo.
echo This utility takes a class list (in CSV format) and uses this to make copies of a test file for each class member.
echo.
echo There are three steps in the process:
echo. 
echo 1. Choose the CSV source file,
echo.
echo 2. Choose the file to be copied, and 
echo.
echo 3. Choose a folder in which the copies are to be placed.
echo.
echo ___________________________
echo.
pause
cls
:csvOver
set csvName=""
set response1=""

echo. 
echo ___________________________
echo.
echo Step 1: Drag the class list (.csv) file here and press enter...
echo.
echo ___________________________
echo.
set /p csvName=""

for %%i in (%csvName%) do set cext=%%~xi
for %%i in (%csvName%) do set className=%%~ni
echo.

(if %cext% NEQ .csv (echo Sorry - you need a csv file for this. Try again? y/n) & (set /p response1=""))
(if not exist %csvName% (echo Sorry - cannot find this file. Try again? y/n) & (set /p response1=""))
if %response1%==n (Exit)
if %response1%==y (GOTO csvOver)

:startOver
set fileName=""
set response=""

echo.
echo ___________________________
echo.
echo Step 2: Drag the test file to be copied on to this window and press enter...
echo.
echo ___________________________
echo.
set /p fileName=""

for %%i in (%fileName%) do set ext=%%~xi
for %%i in (%fileName%) do set testName=%%~ni
echo.

(if not exist %fileName% (echo Sorry - cannot find this file. Try again? y/n) & (set /p response=""))
if %response%==n (Exit)
if %response%==y (GOTO startOver)

echo.
echo ___________________________

echo.
echo Step 3: Drag the destination folder or type a name to create a new folder...
echo.
echo ___________________________
echo.
set /p folderName=""
if not exist %folderName% (md %pathName%%folderName%)

SETLOCAL ENABLEDELAYEDEXPANSION
for /f "tokens=1,2 delims=," %%i in (%csvName%) do (
echo.

(set myFile=%%j_%%i)

Set DRV=!myFile:~0,1!
if "!DRV!" EQU "_" (set myFile=%%i)

REM set DATEST=!testName!_%DATE:~10,4%%DATE:~4,2%%DATE:~7,2%-%TIME:~0,2%%TIME:~3,2%%TIME:~6,2%
REM set DATEST1=!className!_%DATE:~10,4%%DATE:~4,2%%DATE:~7,2%-%TIME:~0,2%%TIME:~3,2%%TIME:~6,2%

set DATEST=!testName!_%DATE:~10,4%%DATE:~4,2%%DATE:~7,2%
set DATEST1=Class!className!_%DATE:~10,4%%DATE:~4,2%%DATE:~7,2%

REM echo !DATEST!
REM echo !DATEST1!

(if not exist %pathName%%folderName%\!DATEST! md %pathName%%folderName%\!DATEST!)
(if not exist %pathName%%folderName%\!DATEST1! md %pathName%%folderName%\!DATEST1!)

echo !myFile!%ext%

if exist %pathName%%folderName%\!myFile!%ext% (
move %pathName%%folderName%\!myFile!%ext% %pathName%%folderName%\!DATEST1!\!myFile!%ext%

)

copy %fileName% %folderName%\!myFile!%ext% /y
copy %fileName% %folderName%\!DATEST!\!myFile!%ext% /y

)
)
endlocal