-- Script Tutorial 10
-- Steve Arnold

	function on.timer()
	    platform.window:invalidate()
	end


	function on.create()
    	timer.start(1/5)
	end


function drawArray(number, x, y, length, height)
    types = (var.recall("type") or 1)
    if types == 1 then
        for k = 0, number do
            for m = 0, number do
                platform.gc():drawLine(x,y + (height)*(m),x + (length)*(number),y + (height)*(m))
                platform.gc():drawLine(x + (length)*(k),y,x + (length)*(k),y + height*(number))
            end
         end
    elseif types == 2 then
        for k = 0, number + 1 do
            for m = 0, number do
                platform.gc():drawLine(x,y + (height)*(m),x + (length)*(number+1),y + (height)*(m))
                platform.gc():drawLine(x + (length)*(k),y,x + (length)*(k),y + height*(number))
            end
        end
    else
        for k = 0, number - 1 do
            for m = k, number - 1 do
                 platform.gc():drawLine(x, y, x + (length)*(number+1) - length, y )         
                 platform.gc():drawLine(x + length*(m), y + (height)*(m+1), x + (length)*(number), y + (height)*(m+1))
                 platform.gc():drawLine(x + (length)*(k), y, x + (length)*(k), y + height*(k+1))
                 platform.gc():drawLine(x + (length)*(number), y, x + (length)*(number), y + height*(number))
            end
        end
    end
end 

function drawCircles(number, x, y, length, height)

    types = (var.recall("type") or 1)

    if types == 1 then

        for k = 0, number - 1 do
            for m = 0, number - 1 do
                platform.gc():fillArc(x + (length)*(m),y + (height)*(k),length, height, 0, 360)
            end
        end
    elseif types == 2 then
        for k = 0, number - 1 do
            for m = 0, number do
                platform.gc():fillArc(x + (length)*(m),y + (height)*(k),length, height, 0, 360)
            end
        end
    else
        for k = 0, number - 1 do
            for m = k, number - 1 do
                platform.gc():fillArc(x + (length)*(m),y + (height)*(k),length, height, 0, 360)
            end
        end
    end 
end


function on.arrowDown()
    num = (var.recall("n") or 1)
    if num > 0 then
        var.store("n", num - 1)
    else
        var.store("n", 1)
    end

end

function on.arrowUp()
    num = (var.recall("n") or 1)
    var.store("n", num + 1)

end

function on.arrowLeft()
    types = (var.recall("type") or 1)
    if types > 1 then
        var.store("type", types - 1)
    else
        var.store("type", 1)
    end

end

function on.arrowRight()
    types = (var.recall("type") or 1)
    num = (var.recall("n") or 1)
    if types < num then
        var.store("type", types + 1)
    else
        var.store("type", num)
    end

end


function on.escapeKey()
    tabs = (var.recall("tab") or 1)
    if tabs > 0 then
        var.store("tab", tabs - 1)
    else
        var.store("tab", 1)
    end

end

function on.tabKey()
    tabs = (var.recall("tab") or 1)
    num = (var.recall("n") or 1)
    if tabs < num + 1 then
        var.store("tab", tabs + 1)
    else
        var.store("tab", num)
    end

end


function on.paint(gc)

    w = platform.window:width()
    h = platform.window:height()
    num = (var.recall("n") or 1)
    tabs = (var.recall("tab") or 1)
    xval = math.floor(w/(num+4))
    yval = math.floor(h/(num+4))
    x = w/2 - (num)*(xval)/2
    y = h/2 - (num)*(yval)/2
 
    gc:setPen("thin", "smooth")
    gc:setColorRGB(165,42,42)
    drawArray(num, x, y, xval, yval)    
    drawCircles(tabs, x, y, xval, yval)

end 
