

Colour = {
	red 		= {0xFF, 0x00, 0x00},
	green		= {0x00, 0xFF, 0x00},
}

TrackedObject = nil
TrackOffsetx = 0
TrackOffsety = 0

function on.resize()

    w = platform.window:width()
    h = platform.window:height()
    platform.window:invalidate()
    
    end

Square = class()

function Square:init(x, y, width, height)
	self.x		= x
	self.y		= y
	self.width	= width or 20
	self.height	= height or 20
	self.colour = Colour.green
	self.selected = false
end


function Square:contains(x, y)
	local sw = self.width
	return x >= self.x and x <= self.x + sw and
	       y >= self.y and y <= self.y + sw
end


function Square:paint(gc)
	gc:setColorRGB(unpack(self.colour))
	gc:fillRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
	if self.selected then
	gc:setPen("medium","smooth")
	gc:setColorRGB(0, 0, 0)
	gc:drawRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
    end	
end


Circle = class()

function Circle:init(x, y, width, height)
	self.x = x
	self.y = y
	self.width = width * 2
	self.height = height * 2
	self.radius = height
	self.colour = Colour.red
	self.selected = false
end


function Circle:contains(x, y)
	local r = self.radius
	local d = math.sqrt((self.x - x)^2 + (self.y - y)^2)
	return d <= r
end

function Circle:paint(gc)
	local cx = self.x - self.radius
	local cy = self.y - self.radius
	local diameter = 2*self.radius
	gc:setColorRGB(unpack(self.colour))
	gc:fillArc(cx, cy, diameter, diameter, 0, 360)
	if self.selected then
	    gc:setPen("medium","smooth")
	    gc:setColorRGB(0, 0, 0)
	gc:drawArc(cx, cy, diameter, diameter, 0, 360)
    end	

end

Objects = {
	Circle(160, 120, 20, 20),
	Square(80, 40, 40, 40),
}

function on.tabKey()

           if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        end

        for i = #Objects, 1, -1 do
	    local obj = Objects[i]

	        if obj == TrackedObject  then
	            TrackedObject = Objects[i+1]
	            break
	        end
	   end
	        
		    if TrackedObject == nil then
		       TrackedObject = Objects[1]
		       end
		       
 		    
			TrackedObject.selected = true
			platform.window:invalidate()
			
end

function on.arrowRight()

    if TrackedObject ~= nil then
    if TrackedObject.x < w - TrackedObject.width / 2 then
        TrackedObject.x = TrackedObject.x + 5
        end
    end
 
end

function on.arrowLeft()

    if TrackedObject ~= nil then
    if TrackedObject.x > TrackedObject.width / 2 then
        TrackedObject.x = TrackedObject.x - 5
        end
    end
 
end


function on.arrowDown()

    if TrackedObject ~= nil then
    if TrackedObject.y < h - TrackedObject.height / 2 then
        TrackedObject.y = TrackedObject.y + 5
        end
    end
 
end

function on.arrowUp()

    if TrackedObject ~= nil then
    if TrackedObject.y > TrackedObject.height / 2 then
        TrackedObject.y = TrackedObject.y - 5
        end
    end
 
end

function on.escapeKey()
        if TrackedObject ~= nil then
            TrackedObject.selected= false
            TrackedObject = nil
            end
end



function on.mouseDown(x,y)
	--for i, obj in ipairs(Objects) do
	
	for i = #Objects, 1, -1 do
	    local obj = Objects[i]
		if obj:contains(x, y) then
		    if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        end
		    
			TrackedObject = obj
			obj.selected = true
			TrackOffsetx = TrackedObject.x - x
			TrackOffsety = TrackedObject.y - y
			table.remove(Objects, i)
			table.insert(Objects, obj)
			platform.window:invalidate()
			break
		end
	end
end


function on.mouseUp(x,y)
		    if TrackedObject ~= nil then
		        TrackedObject.selected = false
		       end    
    	TrackedObject = nil
end


function on.mouseMove(x,y)
	if TrackedObject ~= nil then
		TrackedObject.x = x + TrackOffsetx
		TrackedObject.y = y + TrackOffsety
		platform.window:invalidate()
	end
end



function on.paint(gc)
	for _, obj in ipairs(Objects) do
		obj:paint(gc)
	end
end


