platform.apilevel = '1.0'
-- Introduction to Classes
-- Steve Arnold November 17 2011

-------------------------------------------------------------------------------------
Color = {
    red = {0xFF, 0x00, 0x00},
    green	 = {0x00, 0xFF, 0x00},
}

W = platform.window:width()
H = platform.window:height()

TrackedObject = nil

Square = class()

function Square:init(x, y, width, height)
    self.x	 = x
    self.y	 = y
    self.width	= width or 20
    self.height	= height or 20
    self.color = Color.green
    self.selected = false
end

  
  
function Square:contains(x, y)
    local sw = self.width
    local sh = self.height

    return x >= self.x - sw/2 and x <= self.x + sw/2 and
           y >= self.y - sh/2 and y <= self.y + sh/2
end

  
  
function Square:paint(gc)
    gc:setColorRGB(unpack(self.color))
    gc:fillRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)

    if self.selected then
        gc:setPen("medium","smooth")
        gc:setColorRGB(0, 0, 0)
        gc:drawRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
    end
end

Sq = Square(W/2, H/2, W/10, W/10)


function on.mouseDown(x,y)
	
		if Sq:contains(x, y) then
		    if TrackedObject ~= nil then
		       TrackedObject.selected = false
		    end
		    
			TrackedObject = Sq
			Sq.selected = true
			platform.window:invalidate()
	end
end


function on.mouseUp(x,y)
		    if TrackedObject ~= nil then
		        TrackedObject.selected = false
		       end    
    	TrackedObject = nil
end


function on.mouseMove(x,y)
	if TrackedObject ~= nil then
		TrackedObject.x = x
		TrackedObject.y = y
		platform.window:invalidate()
	end
end


  
function on.paint(gc)
    Sq:paint(gc)

	if TrackedObject ~= nil then
        gc:setFont("sansserif", "b", 10)
        gc:setColorRGB(unpack(Sq.color))
        gc:drawString("("..TrackedObject.x..","..TrackedObject.y..")",20,20)
    end
end