
function on.resize()

	Color = {
		red = {0xFF, 0x00, 0x00},
		green	 = {0x00, 0xFF, 0x00},
}

	W = platform.window:width()
	H = platform.window:height()

	TrackedObject = nil

	Objects = {
		Circle(W/2, H/2, W/20, W/20),
		Square(W/2, H/2, W/10, W/10),
	}

end


Square = class()

function Square:init(x, y, width, height)
	self.x	 = x
	self.y	 = y
	self.width	= width or 20
	self.height	= height or 20
	self.color = Color.green
	self.selected = false
end
  
function Square:contains(x, y)
	local sw = self.width
	local sh = self.height

	return x >= self.x - sw/2 and x <= self.x + sw/2 and
			y >= self.y - sh/2 and y <= self.y + sh/2
end
  
function Square:paint(gc)
	gc:setColorRGB(unpack(self.color))
	gc:fillRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
	if self.selected then
		gc:setPen("medium","smooth")
		gc:setColorRGB(0, 0, 0)
		gc:drawRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
	end
end


Circle = class()

function Circle:init(x, y, width, height)
	self.x = x
	self.y = y
	self.width = width * 2
	self.height = height * 2
	self.radius = height
	self.color = Color.red
	self.selected = false
end

function Circle:contains(x, y)
	local r = self.radius
	local d = math.sqrt((self.x - x)^2 + (self.y - y)^2)

	return d <= r
end

function Circle:paint(gc)
	local cx = self.x - self.radius
	local cy = self.y - self.radius
	local diameter = 2*self.radius
	gc:setColorRGB(unpack(self.color))
	gc:fillArc(cx, cy, diameter, diameter, 0, 360)
	if self.selected then
		gc:setPen("medium","smooth")
		gc:setColorRGB(0, 0, 0)
		gc:drawArc(cx, cy, diameter, diameter, 0, 360)
	end
end


function on.arrowRight()
	if TrackedObject ~= nil then
		if TrackedObject.x < W - TrackedObject.width / 2 then
			TrackedObject.x = TrackedObject.x + 5
		end
	end
end

function on.arrowLeft()
	if TrackedObject ~= nil then
		if TrackedObject.x > TrackedObject.width / 2 then
			TrackedObject.x = TrackedObject.x - 5
		end
	end
end

function on.arrowDown()
	if TrackedObject ~= nil then
		if TrackedObject.y < H - TrackedObject.height / 2 then
			TrackedObject.y = TrackedObject.y + 5
		end
	end
end

function on.arrowUp()
	if TrackedObject ~= nil then
		if TrackedObject.y > TrackedObject.height / 2 then
			TrackedObject.y = TrackedObject.y - 5
		end
	end
end

function on.escapeKey()
	if TrackedObject ~= nil then
		TrackedObject.selected= false
		TrackedObject = nil
	end
end


function on.tabKey()
	if TrackedObject ~= nil then
		TrackedObject.selected = false
	end

	for i = #Objects, 1, -1 do
		local obj = Objects[i]
		if obj == TrackedObject then
			TrackedObject = Objects[i+1]
			break
		end
	end
	
	if TrackedObject == nil then
		TrackedObject = Objects[1]
	end

	TrackedObject.selected = true
	platform.window:invalidate()
end


function on.paint(gc)

	for _, obj in ipairs(Objects) do
		obj:paint(gc)
	end

	if TrackedObject ~= nil then
		gc:setFont("sansserif", "b", 10)
		gc:setColorRGB(unpack(TrackedObject.color))
		gc:drawString("("..TrackedObject.x.."," ..TrackedObject.y..")",20,20)
	end
end
