

Colour = {
	red 		= {0xFF, 0x00, 0x00},
	green		= {0x00, 0xFF, 0x00},
}

TrackedObject = nil
TrackOffsetx = 0
TrackOffsety = 0
    w = platform.window:width()
    h = platform.window:height()

function on.resize()

    w = platform.window:width()
    h = platform.window:height()
    platform.window:invalidate()
    
    end

Square = class()

function Square:init(x, y, width, height)
	self.x		= x
	self.y		= y
	self.width	= width or 20
	self.height	= height or 20
	self.colour = Colour.green
	self.selected = false
end


function Square:contains(x, y)
	local sw = self.width
	local sh = self.height
	return x >= self.x - sw/2 and x <= self.x + sw/2 and
	       y >= self.y - sh/2 and y <= self.y + sh/2
end


function Square:paint(gc)
	gc:setColorRGB(unpack(self.colour))
	gc:fillRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
	if self.selected then
	gc:setPen("medium","smooth")
	gc:setColorRGB(0, 0, 0)
	gc:drawRect(self.x - self.width / 2, self.y - self.height / 2, self.width, self.height)
    end	
end


Circle = class()

function Circle:init(x, y, width, height)
	self.x = x
	self.y = y
	self.width = width * 2
	self.height = height * 2
	self.radius = height
	self.colour = Colour.red
	self.selected = false
end


function Circle:contains(x, y)
	local r = self.radius
	local d = math.sqrt((self.x - x)^2 + (self.y - y)^2)
	return d <= r
end

function Circle:paint(gc)
	local cx = self.x - self.radius
	local cy = self.y - self.radius
	local diameter = 2*self.radius
	gc:setColorRGB(unpack(self.colour))
	gc:fillArc(cx, cy, diameter, diameter, 0, 360)
	if self.selected then
	    gc:setPen("medium","smooth")
	    gc:setColorRGB(0, 0, 0)
	gc:drawArc(cx, cy, diameter, diameter, 0, 360)
    end	

end

Objects = {
	Circle(0.9*w, h/3, w/20, w/20),
	Square(0.9*w, 2*h/3, w/10, w/10),
}

function on.tabKey()

           if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        end

        for i = #Objects, 1, -1 do
	    local obj = Objects[i]

	        if obj == TrackedObject  then
	            TrackedObject = Objects[i+1]
	            break
	        end
	   end
	        
		    if TrackedObject == nil then
		       TrackedObject = Objects[1]
		       end
		       
 		    
			TrackedObject.selected = true
			platform.window:invalidate()
			
end

function on.arrowRight()

    if TrackedObject ~= nil then
    if TrackedObject.x < w - TrackedObject.width / 2 then
        TrackedObject.x = TrackedObject.x + 5
        end
    end
 
end

function on.arrowLeft()

    if TrackedObject ~= nil then
    if TrackedObject.x > TrackedObject.width / 2 then
        TrackedObject.x = TrackedObject.x - 5
        end
    end
 
end


function on.arrowDown()

    if TrackedObject ~= nil then
    if TrackedObject.y < h - TrackedObject.height / 2 then
        TrackedObject.y = TrackedObject.y + 5
        end
    end
 
end

function on.arrowUp()

    if TrackedObject ~= nil then
    if TrackedObject.y > TrackedObject.height / 2 then
        TrackedObject.y = TrackedObject.y - 5
        end
    end
 
end

function on.escapeKey()

Objects = {
	Circle(0.9*w, h/3, w/20, w/20),
	Square(0.9*w, 2*h/3, w/10, w/10),
}

        if TrackedObject ~= nil then
            TrackedObject.selected= false
            TrackedObject = nil
            end
end

function on.enterKey()
	if TrackedObject ~= nil then
			if TrackedObject.colour == Colour.green then
			    table.insert(Objects, Square(TrackedObject.x, TrackedObject.y, w/10, w/10))
			else
			    table.insert(Objects, Circle(TrackedObject.x, TrackedObject.y, w/20, w/20))
			end
        end
end

function on.mouseDown(x,y)
	--for i, obj in ipairs(Objects) do
	
	for i = 1, #Objects do
	    local obj = Objects[i]
		if obj:contains(x, y) then

		    if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        end
		    
			TrackedObject = obj
			obj.selected = true
			if obj.colour == Colour.green then
			table.insert(Objects, Square(x, y, w/10, w/10))
			else
			table.insert(Objects, Circle(x, y, w/20, w/20))
			end
			TrackOffsetx = TrackedObject.x - x
			TrackOffsety = TrackedObject.y - y
			table.remove(Objects, i)
			table.insert(Objects, obj)
			platform.window:invalidate()
			break
		end
	end
end


function on.mouseUp(x,y)
		    if TrackedObject ~= nil then
		        TrackedObject.selected = false
		       end    
    	TrackedObject = nil
end


function on.mouseMove(x,y)
	if TrackedObject ~= nil then
		TrackedObject.x = x + TrackOffsetx
		TrackedObject.y = y + TrackOffsety
		platform.window:invalidate()
	end
end



function on.paint(gc)
	for _, obj in ipairs(Objects) do
		obj:paint(gc)
	end
end


