platform.apilevel = '1.0'
-- Shape Numbers Explorer
-- Steve Arnold August 31 2011

-------------------------------------------------------------------------------------
Colour = {
    red         = {0xFF, 0x00, 0x00},
    green       = {0x00, 0xFF, 0x00},
    blue        = {0x00, 0x00, 0xFF},
    black       = {0x00, 0x00, 0x00},
}


TrackedObject = nil
TrackOffsetx = 0
TrackOffsety = 0
w = platform.window:width()
h = platform.window:height()
num = 1 
tabnum = 0
types = 1
shw = 3

    

function on.resize()
    w = platform.window:width()
    h = platform.window:height()

    Circle1 = Circle(w/10, h/10, w/12, h/15)
    Circle2 = Circle(9*w/10, 9*h/10, w/12, h/15)
    Square1 = Square(w/10 - w/20, h/3, w/20)
    Rectangle1 = Rectangle(w/10 - w/20, h/2, w/15, w/20)
    Triangle1 = Triangle(w/10 - w/20, 2*h/3 + w/20, w/20)
    
    Objects = {
        Circle1, Circle2, Square1, Rectangle1, Triangle1    
    }

    platform.window:invalidate()
end

-------------------------------------------------------------------------------------

Circle = class()

function Circle:init(x, y, width, height)

    self.x = x
    self.y = y
    self.width = width
    self.height = height
    self.radius = height/2
    self.colour = Colour.blue
    self.selected = false
end


function Circle:contains(x, y)

    local r = self.radius
    local d = math.sqrt((self.x - x)^2 + (self.y - y)^2)
    return d <= r
end


function Circle:paint(gc)

    local cx = self.x - self.radius
    local cy = self.y - self.radius
    local diameter = 2*self.radius
    gc:setColorRGB(unpack(self.colour))
    gc:fillArc(cx, cy, diameter, diameter, 0, 360)
    if self.selected then
        gc:setPen("medium","smooth")
        gc:setColorRGB(0, 0, 0)
        gc:drawArc(cx, cy, diameter, diameter, 0, 360)
    end 
    platform.window:invalidate()
end

-------------------------------------------------------------------------------------

Square = class()

function Square:init(x, y, size)

    self.x = x
    self.y = y
    self.width = size
    self.colour = Colour.green
    self.selected = false
end


function Square:contains(x, y)
    local w = self.width
    return x >= self.x and x <= self.x + w and
           y >= self.y and y <= self.y + w
end


function Square:paint(gc)
    local cx = self.x
    local cy = self.y
    local size = self.width
    gc:setColorRGB(unpack(self.colour))
    gc:fillRect(cx, cy, size, size)
    if self.selected then
        gc:setPen("medium","smooth")
        gc:setColorRGB(255, 0, 0)
        gc:fillRect(cx, cy, size, size)
        gc:setColorRGB(0, 0, 0)
        gc:drawRect(cx, cy, size, size)
    end 
    platform.window:invalidate()
end


-------------------------------------------------------------------------------------

Rectangle = class()

function Rectangle:init(x, y, width, height)

    self.x = x
    self.y = y
    self.width = width
    self.height = height
    self.colour = Colour.blue
    self.selected = false
end


function Rectangle:contains(x, y)
    local w = self.width
    local h = self.height
    return x >= self.x and x <= self.x + w and
           y >= self.y and y <= self.y + h
end


function Rectangle:paint(gc)
    local cx = self.x
    local cy = self.y
    local width = self.width
    local height = self.height
    gc:setColorRGB(unpack(self.colour))
    gc:fillRect(cx, cy, width, height)
    if self.selected then
        gc:setPen("medium","smooth")
        gc:setColorRGB(255, 0, 0)
        gc:fillRect(cx, cy, width, height)
        gc:setColorRGB(0, 0, 0)
        gc:drawRect(cx, cy, width, height)
    end 
    platform.window:invalidate()
end

-------------------------------------------------------------------------------------

Triangle = class()

function Triangle:init(x, y, size)

    self.x = x
    self.y = y
    self.width = size
    self.colour = Colour.red
    self.selected = false
end


function Triangle:contains(x, y)

    local w = self.width
    return x >= self.x and x <= self.x + w and
           y >= self.y - w and y <= self.y
end


function Triangle:paint(gc)
    local cx = self.x
    local cy = self.y
    local size = self.width
    local vertices = {cx, cy, cx + size, cy, cx + size/2, cy - size, cx, cy}
    gc:setColorRGB(unpack(self.colour))
    gc:fillPolygon(vertices)
    if self.selected then
        gc:setPen("medium","smooth")
        --gc:setColorRGB(255, 0, 0)
        --gc:fillPolygon(vertices)
        gc:setColorRGB(unpack(Colour.black))
        gc:drawPolyLine(vertices)
    end 
    platform.window:invalidate()
end

-------------------------------------------------------------------------------------

function on.mouseDown(x,y)
    
    for i = #Objects, 1, -1 do
        local obj = Objects[i]
        if obj:contains(x, y) then

            if TrackedObject ~= nil then
                TrackedObject.selected = false
            end
            TrackedObject = obj
            obj.selected = true
            TrackOffsetx = TrackedObject.x - x
            TrackOffsety = TrackedObject.y - y
            table.remove(Objects, i)
            table.insert(Objects, obj)
            platform.window:invalidate()
            break
        end
    end
    if TrackedObject == Triangle1 then
        types = 3
    elseif TrackedObject == Rectangle1 then
        types = 2
    elseif TrackedObject == Square1 then
        types = 1
    end
    
    platform.window:invalidate()    
    
end


function on.mouseUp(x,y)
    if TrackedObject ~= nil then
        TrackedObject.selected = false
    end    
    TrackedObject = nil
    platform.window:invalidate()
end


function on.mouseMove(x,y)
    w = platform.window:width()
    h = platform.window:height()

    if TrackedObject ~= nil and num < 25 then
        if TrackedObject == Circle2 then
            if y > h/10 and y < 9*h/10 then
                TrackedObject.y = y + TrackOffsety
        
                num = math.floor(20*(0.9*h-TrackedObject.y)/(0.9*h)+1)
        
                TrackedObject.x = 9*w/10
    
            end
        elseif TrackedObject == Circle1 then
            if x > w/10 - TrackedObject.width/4 and x < math.floor((num)*w/(num+1)) then
                TrackedObject.x = x + TrackOffsetx
        
                tabnum = math.floor(num*TrackedObject.x/(w)+0.5)
        
                TrackedObject.y = h/10
    
            end        
       end
   end
   platform.window:invalidate()
end

-------------------------------------------------------------------------------------


function on.arrowUp()

    if  num < 18 then
        num = num + 1
        Circle2.y = h - h*num/20
    end    
    platform.window:invalidate()
end


function on.arrowDown()

    if num > 1 then
        num = num - 1
        Circle2.y = h - h*num/20
    end    
    platform.window:invalidate()
end


function on.arrowLeft()

    if tabnum > 0 then
        tabnum = tabnum - 1
        Circle1.x = w/10 + tabnum*w/(num+1)
    end    
    platform.window:invalidate()
end


function on.arrowRight()
    if tabnum < num - 1 then
        tabnum = tabnum + 1
        Circle1.x = w/10 + tabnum*w/(num+1)
    end    
    platform.window:invalidate()
end


function on.enterKey()
    if types < 4 then
        types = types % 3 + 1
    else
        types = 3
    end    
    platform.window:invalidate()
end


function on.escapeKey()
    if types < 4 then
        types = types % 3 - 1
    else
        types = 3
    end    
    platform.window:invalidate()
end


function on.tabKey()

 --   if TrackedObject ~= nil then
 --       TrackedObject.selected = false
 --   end

--    for i = #Objects, 1, -1 do
--        local obj = Objects[i]

--        if obj == TrackedObject  then
--            TrackedObject = Objects[i+1]
--            break
--        end
--    end
        
--    if TrackedObject == nil then
--       TrackedObject = Objects[1]
--    end
           
--    TrackedObject.selected = true

    shw = (shw + 1) % 4
    platform.window:invalidate()
            
end

-------------------------------------------------------------------------------------

function counter(tabnum, gc)
    local w = platform.window:width()
    local h = platform.window:height()
    local xval = math.floor(h/(num+4))
    local yval = math.floor(h/(num+4))
    local x = w/2 - (num)*(xval)/2
    local y = h/2 - (num)*(yval)/2

    gc:setPen("thin", "smooth")     
    if types == 1 then
        if tabnum == 0 then
            gc:setColorRGB(20, 20, 138)
            gc:fillArc(x, y, xval, yval, 0, 360)
        else
 
            for k = 0, tabnum do
                gc:setColorRGB((20+25*k) % 255, (20+25*k) % 255, (138-25*k) % 255)
                for m = 0, tabnum do
                    gc:fillArc(x + (xval)*(m), y + (yval)*(k), xval, yval, 0, 360)
                end
            end
        end
    elseif types == 2 then
        
        if tabnum == 0 then
            gc:setColorRGB(20, 20, 138)
            gc:fillArc(x, y, xval, yval, 0, 360)
            gc:fillArc(x + xval, y, xval, yval, 0, 360)
        else
 
            for k = 1, tabnum + 1 do
                gc:setColorRGB((20+25*k) % 255, (20+25*k) % 255, (138-25*k) % 255)
                for m = 0, tabnum + 1 do
                    gc:fillArc(x + (xval)*(m), y + yval*(k-1), xval, yval, 0, 360)
                end
            end
        end


    else
        for k = 0, tabnum do
            gc:setColorRGB((20+25*k) % 255, (20+25*k) % 255, (138-25*k) % 255)
            for m = k, tabnum do
                gc:fillArc(x + (xval)*(m), y + yval*(k), xval, yval, 0, 360)
            end
        end
    end
    platform.window:invalidate()
end

-------------------------------------------------------------------------------------

function drawArray(number, x, y, length, height, gc)
    w = platform.window:width()
    h = platform.window:height()
    
    if types == 1 then
        if shw ==1 then
            gc:drawRect(x, y, (length)*(number+1) - length, height*(number))
            for k = 1, number do
                for m = 1, number do
                    gc:drawArc(x + (length)*(m-1), y + (height)*(k-1), length, height, 0, 360)
                end
            end
        elseif shw == 2 then
       
            for k = 0, number do
                for m = 0, number do
         
                    gc:drawLine(x, y + (height)*(m), x + (length)*(number), y + (height)*(m))
                    gc:drawLine(x + (length)*(k), y, x + (length)*(k), y + height*(number))
         
                end
            end    
       
        else
            for k = 1, number do
                for m = 1, number do
                    gc:drawArc(x + (length)*(m-1), y + (height)*(k-1), length, height, 0, 360)
                end
            end
        end
    elseif types == 2 then
        if shw ==1 then
            gc:drawRect(x, y, length*(number+1), height*(number))    
            for k = 1, number do
                for m = 0, number do
                    gc:drawArc(x + (length)*(m), y + height*(k-1), length, height, 0, 360)
                end
            end
        elseif shw == 2 then
            for k = 0, number+1 do
                for m = 0, number do
         
                    gc:drawLine(x, y + (height)*(m), x + (length)*(number+1), y + (height)*(m))
                    gc:drawLine(x + (length)*(k), y, x + (length)*(k), y + height*(number))
         
                end
            end    

        else
            for k = 2, number+1 do
                for m = 1, number+1 do
                    gc:drawArc(x + (length)*(m-1), y + height*(k-2), length, height, 0, 360)
                end
            end
        end
    else

        if shw == 1 then
            gc:drawPolyLine({x - 0.7*length, y, x + (number)*length, y, x + (number)*length, y + (number+1)*height - height/5, x - 0.7*length, y})
            for k = 1, number do
                for m = k, number do
                    gc:drawArc(x + length*(m-1), y + height*(k-1), length, height, 0, 360)
                end
            end
        elseif shw == 2 then
       
            for k = 1, number do
                for m = k, number do
                 
                    gc:drawLine(x, y, x + (length)*(number+1) - length, y )         
                    gc:drawLine(x + length*(m-1), y + (height)*(m), x + (length)*(number), y + (height)*(m))
                    gc:drawLine(x + (length)*(m-1), y, x + (length)*(m-1), y + height*(m))
                    gc:drawLine(x + (length)*(number), y, x + (length)*(number), y + height*(number))
          
                end
            end    
       
        else
            for k = 1, number do
                for m = k, number do
                    gc:drawArc(x + length*(m-1), y + height*(k-1), length, height, 0, 360)
                end
            end
        end
     end
    platform.window:invalidate()
end

-------------------------------------------------------------------------------------
 
function on.paint(gc)


    for _, obj in ipairs(Objects) do
        obj:paint(gc)
    end

    w = platform.window:width()
    h = platform.window:height()
     
    if tabnum > -1 and tabnum < num then
        counter(tabnum, gc)
    end
     
    xval = math.floor(h/(num+4))
    yval = math.floor(h/(num+4))
    x = w/2 - (num)*(xval)/2
    y = h/2 - (num)*(yval)/2

    gc:setColorRGB(165,42,42)
    gc:setPen("thin", "smooth")
    
    drawArray(num, x, y, xval, yval, gc)

    gc:setFont("sansserif", "b", 10)
    gc:setColorRGB(20, 20, 138)
    
    if types == 1 then
        str1 = "Square Numbers"
        str2 = num.." × "..num.." = "..num^2
        str3 = "1"
        for k = 2, tabnum + 1 do
             str3 = str3.."+"..2*k - 1
        end
    elseif types == 2 then
        str1 = "Rectangular Numbers"
        str2 = num.." × "..(num+1).." = "..num*(num+1)
        str3 = "2"
        for k = 2, tabnum + 1 do
            str3 = str3.."+"..2*k
        end
    else
        str1 = "Triangular Numbers"
        str2 = "("..num.." × "..(num+1)..")/2 = "..num*(num+1)/2
        str3 = "1"
        for k = 2, tabnum + 1 do
              str3 = str3.."+"..k
        end

    end
    strwidth = gc:getStringWidth(str1..": "..str2)
    gc:drawString(str1..": "..str2, (w - strwidth)/2 , h-5, "bottom")
    
     gc:setFont("sansserif", "b", 8)
    gc:setColorRGB(20, 20, 138)
   
    strwidth = gc:getStringWidth(str3)
    gc:drawString(str3, (w - strwidth)/2 , 0, "top")

    gc:setFont("sansserif", "i", 8)
    gc:setColorRGB(0, 0, 255)

    gc:drawString(" n", 9.25*w/10,h/2)
    gc:drawString("▼", 9.25*w/10,3*h/5)
    gc:drawString("▲", 9.25*w/10,2*h/5)


    local sw = gc:getStringWidth("◀ Build ▶") 
    gc:drawString("◀ Build ▶", w/2 - sw/2,h/10, "top")
    gc:drawString("   ▲", 0.25*w/10,8.25*h/10)
    gc:drawString("Choose", 0.25*w/10,9*h/10)
    gc:drawString("Type", 0.25*w/10,9.5*h/10)
   
    gc:setColorRGB(0,0,255)
    gc:setPen("thin", "dotted")
    gc:drawLine(w/10,h/10,9*w/10,h/10)
    gc:drawLine(9*w/10,h/10,9*w/10,9*h/10)
 
    platform.window:invalidate()
    
end

