
Input = ""
Display = ""
Vinculum = 0
keyColumns = 8
Size = 11
TrackOffsetx = 0
TrackOffsety = 0


function deleter()
	Display = Display:sub(0,Display:len()-1)
	Input = Input:sub(0,Input:len()-1)
	platform.window:invalidate()
end

    
function input_actions(keypad, char)
	---get the user's input

	chard = char

	if Input ~= "" then
		if char == "(" and charold == ")" then
			char = "*("
		end
	end

    if char == "esc" then
            Input = ""
            Display = ""
            Result = ""
            Output = ""
            Size = 11
            Show = 0
            Switch = 0
            return
    end

    if char == "tab" then
    	if Show == 0 then
		Show = 1
	else
		Show = 0
	end
	return
    end
    
    
 
	if char == " " then
		char = ""
		chard = char
	end


	if char == "−" then
		char = "-"
		chard = char
	end

    if char == "÷" then
        char = "/"
        chard = char
     end

	if char == "/" or char == "÷" then
		Vinculum = 1
		platform.window:invalidate()
	end

	if char == "x" then
		xvar = 1
		show = 0
		align = 1
		platform.window:invalidate()
	end

 --[[   if char == "x²" then
            char = "x^2"
            chard = "x²"

    end

    if char == "^2" then
            char = "^2"
            chard = "²"
    end]]

    if char == "π" then
            char = math.pi
            chard = "π"

     end



    if char == "space" then
        char = " "
        chard = " "
    end

	charold = char
	Input = Input..char

	if char ~= "^" then
		Display = Display..chard
	end

	platform.window:invalidate()
end


function pretty(input)
        input = tostring(input)
        
        input = input:gsub("−", "-")
        
        input = input:gsub("%+%-", "-")
        input = input:gsub("%-%+", "-")
        input = input:gsub("%+%+", "+")
        input = input:gsub("%-%-", "+")
        
        input = input:gsub("0x%^3%+", "")
        input = input:gsub("0x%^3%-", "")
        input = input:gsub("0x%^2%+", "")
        input = input:gsub("0x%^2%-", "")
        input = input:gsub("0x%+", "")
        input = input:gsub("0x%-", "")
        input = input:gsub("%+0", "")
        input = input:gsub("%-0", "")
        input = input:gsub("1x", "x")
		input = input:gsub("%^2","²")
		input = input:gsub("%^9","⁹")
		input = input:gsub("%^8","⁸")
		input = input:gsub("%^7","⁷")
		input = input:gsub("%^6","⁶")
		input = input:gsub("%^5","⁵")
		input = input:gsub("%^4","⁴")
		input = input:gsub("%^3","³")
		input = input:gsub("%^1","¹")
		input = input:gsub("%^0","⁰")
        input = input:gsub("sqrt","√")
        input = input:gsub("\\","√(")
        input = input:gsub("÷","/")
        
        
        return input
end


function fraction(x, y, input, gc)

     local pre = input
     local post = ""
     local num = ""
     local den = ""
   

    local num, den = unpack(input:split("/"))
    
    if num and num ~= "" then
        pre = ""
        
        if num:find("%(") then
            pre, num = unpack(num:split("%("))
            num = num:sub(0, num:len() - 1)
        else
            while num:find("%+") do
            pre, num = unpack(num:split("%+"))
            pre = pre.."+"
            end
            while num:find("%-") do
            pre, num = unpack(num:split("%-"))
            pre = pre.."-"
            end
        end
    else
        pre = input
        num = ""
    end
    
    if den and den ~= "" then
        if den:find("%)") then
        den, post = unpack(den:split("%)"))
        _, den = unpack(den:split("%("))
        else
            while den:find("%+") do
            den, post = unpack(den:split("%+"))
            post = "+"..post
            end
            while den:find("%-") do
            den, post = unpack(den:split("%-"))
            post = "-"..post
            end
        end

    else
        den = ""
        post = ""
    end
    
    if den == "" then
        pre = num
        num = ""
        post = ""
    end

    local sw1 = math.max(gc:getStringWidth(num),gc:getStringWidth(den))
    local swpre =  1.1*gc:getStringWidth(pre)
    local swpost = 1.1*gc:getStringWidth(post)
    local total = sw1 + swpre + swpost

    gc:drawString(pre, x, y, "middle")
    gc:drawString(num, x + 1.1*swpre + (sw1 - gc:getStringWidth(num))/2, y, "bottom")

    gc:drawLine(x + 1.1*swpre, y, x + 1.1*swpre + sw1, y)

    gc:drawString(den, x + 1.1*swpre + (sw1 - gc:getStringWidth(den))/2, y, "top")
    gc:drawString(post, x + 1.1*(swpre + sw1), y, "middle")

	platform.window:invalidate()
end

--------------------------------------------------------------------------- RectangleClass
RectangleClass = class()

function RectangleClass:init(x, y, width, height, backgroundColor, borderColor, borderWidth, borderPenStyle)
	self.x = x
	self.y = y
	self.width = width
	self.height = height

	-- Drawing defaults
	self.backgroundColor = backgroundColor or { 255, 255, 255 }
	self.borderWidth = borderWidth or "thin"
	self.borderPenStyle = borderPenStyle or "smooth"
	self.borderColor = borderColor or { 50, 50, 250 }
end

function RectangleClass:containsPoint(x, y)
	local sw = self.width
	local sh = self.height
	return x >= self.x and x <= self.x + sw and
    	   y >= self.y and y <= self.y + sh
end

function RectangleClass:paint(graphicsContext)
	graphicsContext:setPen(self.borderWidth, self.borderPenStyle)
	graphicsContext:setColorRGB(unpack(self.borderColor))
	graphicsContext:drawRect(self.x, self.y, self.width, self.height)

	graphicsContext:setColorRGB(unpack(self.backgroundColor))
	graphicsContext:fillRect(self.x, self.y, self.width, self.height)

end


--------------------------------------------------------------------------- KeyPadKeyClass
KeyPadKeyClass = class(RectangleClass)

function KeyPadKeyClass:init(label, visible, highlighted, columns)
	RectangleClass.init(self, 0, 0, 48, 48, { 220, 220, 240 }, { 50, 50, 254 } , "medium", "smooth")
	self.label = label
	self.visible = visible or false
	self.highlighted = false
	self.columns = columns or 1
end

function KeyPadKeyClass:paint(graphicsContext)
	-- Ugh. This should call through to super, but I can't find any documentation about whether super/parent is even implemented :(
	graphicsContext:setPen(self.borderWidth, self.borderPenStyle)
	graphicsContext:setColorRGB(unpack(self.borderColor))
	graphicsContext:drawRect(self.x, self.y, self.width, self.height)
	graphicsContext:setColorRGB(unpack(self.backgroundColor))
	graphicsContext:fillRect(self.x, self.y, self.width, self.height)

	-- Labelly goodness below

	if self.highlighted then
		graphicsContext:setPen("thick", "smooth")

		-- Draw a thick border
		graphicsContext:setColorRGB(0, 0, 0)
		graphicsContext:drawRect(self.x, self.y, self.width, self.height)

		-- Draw a light blue background color
		graphicsContext:setColorRGB(240, 240, 250)
		graphicsContext:fillRect(self.x, self.y, self.width, self.height)
	end

	if self.label == "x" or self.label == "y" then
		graphicsContext:setFont("serif","i",8)
	else
		graphicsContext:setFont("sansserif","r",8)
	end

	local stringWidth = graphicsContext:getStringWidth(self.label)
	local stringHeight = graphicsContext:getStringHeight(self.label)
	graphicsContext:setColorRGB(50, 50, 50)
	graphicsContext:drawString(self.label, self.x + self.width/2 - stringWidth/2, self.y + self.height - stringHeight/2, "bottom")

end


--------------------------------------------------------------------------- KeyPadClass
KeyPadClass = class()

function KeyPadClass:init(visible, keyboard_type)

	self.visible = visible or false

end

function KeyPadKeyClass:containsPoint(x, y)
	local sw = self.width
	local sh = self.height
	return x >= self.x and x <= self.x + sw and
    	   y >= self.y and y <= self.y + sh
end

function KeyPadClass:paint(graphicsContext)
	for objectIndex, objectValue in ipairs(self.keys) do
		objectValue:paint(graphicsContext)
	end
end

function KeyPadClass:layoutKeys()
    
	local keyCount = #self.keys
    local keyColumns = self.keyColumns

	local keyRows = math.floor((keyCount / keyColumns) + 0.9)
	local screenHeight = platform.window:height()
	local screenWidth = platform.window:width()
	local overallKeyPadWidth = screenWidth * 0.8
	local overallKeyPadHeight = screenHeight * 0.4
	
	--print(keyColumns)
	
	
	local keyPadOriginX = (screenWidth - overallKeyPadWidth) / 2
	local keyPadOriginY = screenHeight * 0.6
	local keyPadKeyWidth = overallKeyPadWidth / keyColumns
	local keyPadKeyHeight = overallKeyPadHeight / keyRows

	local keyRow = -1
	local nextXOrigin = keyPadOriginX

	for objectIndex, objectValue in ipairs(self.keys) do
		local keyColumn = (objectIndex - 1) % keyColumns

		if keyColumn == 0 then
			keyRow = keyRow + 1
			nextXOrigin = keyPadOriginX
		end


		objectValue.y = keyPadOriginY + keyRow * keyPadKeyHeight
		objectValue.height = keyPadKeyHeight
		objectValue.width = keyPadKeyWidth * objectValue.columns
		objectValue.x = nextXOrigin

		nextXOrigin = objectValue.x + objectValue.width
		
     if keyColumns == 1 then
	    objectValue.y = screenHeight -  keyPadKeyHeight/4
	    overallKeyPadHeight = screenHeight * 0.1
	    objectValue.height = overallKeyPadHeight
	    overallKeyPadWidth = screenWidth * 0.2
	    objectValue.width = overallKeyPadWidth
	end

	end
end





--------------------------------------------------------------------------- NumericKeyPadClass
NumericKeyPadClass = class(KeyPadClass)

function NumericKeyPadClass:init(visible)
    KeyPadClass.init(self, visible)

    self.keyColumns = 8

    self.keys = {
        KeyPadKeyClass("esc", 1, 1, 1),
        KeyPadKeyClass("=", 1, 1, 1),
        KeyPadKeyClass("x", 1, 1, 1),
        KeyPadKeyClass("7", 1, 1, 1),
        KeyPadKeyClass("8", 1, 1, 1),
        KeyPadKeyClass("9", 1, 1, 1),
        KeyPadKeyClass("y", 1, 1, 1),
        KeyPadKeyClass("del", 1, 1, 1),

        KeyPadKeyClass("x²", 1, 1, 1),
        KeyPadKeyClass("^", 1, 1, 1),
        KeyPadKeyClass("√", 1, 1, 1),
        KeyPadKeyClass("4", 1, 1, 1),
        KeyPadKeyClass("5", 1, 1, 1),
        KeyPadKeyClass("6", 1, 1, 1),
        KeyPadKeyClass("×", 1, 1, 1),
        KeyPadKeyClass("÷", 1, 1, 1),

        KeyPadKeyClass("tab", 1, 1, 1),
        KeyPadKeyClass("(", 1, 1, 1),
        KeyPadKeyClass(")", 1, 1, 1),
        KeyPadKeyClass("1", 1, 1, 1),
        KeyPadKeyClass("2", 1, 1, 1),
        KeyPadKeyClass("3", 1, 1, 1),
        KeyPadKeyClass("+", 1, 1, 1),
        KeyPadKeyClass("-", 1, 1, 1),


        KeyPadKeyClass("keypad", 1, 1, 2),
        KeyPadKeyClass("π", 1, 1, 1),
        KeyPadKeyClass("0", 1, 1, 1),
        KeyPadKeyClass(".", 1, 1, 1),
        KeyPadKeyClass("(-)", 1, 1, 1),
        KeyPadKeyClass("enter", 1, 1, 2),
    }
end






--------------------------------------------------------------------------- QwertyKeyPadClass
QwertyKeyPadClass = class(KeyPadClass)

function QwertyKeyPadClass:init(visible)
    KeyPadClass.init(self, visible)

    self.keyColumns = 12

    self.keys = {
        KeyPadKeyClass("esc", 1, 1, 1),
        KeyPadKeyClass("q", 1, 1, 1),
        KeyPadKeyClass("w", 1, 1, 1),
        KeyPadKeyClass("e", 1, 1, 1),
        KeyPadKeyClass("r", 1, 1, 1),
        KeyPadKeyClass("t", 1, 1, 1),
        KeyPadKeyClass("y", 1, 1, 1),
        KeyPadKeyClass("u", 1, 1, 1),
        KeyPadKeyClass("i", 1, 1, 1),
        KeyPadKeyClass("o", 1, 1, 1),
        KeyPadKeyClass("p", 1, 1, 1),
        KeyPadKeyClass("del", 1, 1, 1),

        KeyPadKeyClass("tab", 1, 1, 1),
        KeyPadKeyClass("a", 1, 1, 1),
        KeyPadKeyClass("s", 1, 1, 1),
        KeyPadKeyClass("d", 1, 1, 1),
        KeyPadKeyClass("f", 1, 1, 1),
        KeyPadKeyClass("g", 1, 1, 1),
        KeyPadKeyClass("h", 1, 1, 1),
        KeyPadKeyClass("j", 1, 1, 1),
        KeyPadKeyClass("k", 1, 1, 1),
        KeyPadKeyClass("l", 1, 1, 1),
        KeyPadKeyClass("|", 1, 1, 1),
        KeyPadKeyClass("'", 1, 1, 1),

        KeyPadKeyClass("!", 1, 1, 1),
        KeyPadKeyClass("?", 1, 1, 1),
        KeyPadKeyClass("z", 1, 1, 1),
        KeyPadKeyClass("x", 1, 1, 1),
        KeyPadKeyClass("c", 1, 1, 1),
        KeyPadKeyClass("v", 1, 1, 1),
        KeyPadKeyClass("b", 1, 1, 1),
        KeyPadKeyClass("n", 1, 1, 1),
        KeyPadKeyClass("m", 1, 1, 1),
        KeyPadKeyClass(":", 1, 1, 1),
        KeyPadKeyClass("<", 1, 1, 1),
        KeyPadKeyClass(">", 1, 1, 1),
        
        KeyPadKeyClass("keypad", 1, 1, 2),
        KeyPadKeyClass("{", 1, 1, 1),
        KeyPadKeyClass("}", 1, 1, 1),
        KeyPadKeyClass("space", 1, 1, 5),
        KeyPadKeyClass(";", 1, 1, 1),
        KeyPadKeyClass("enter", 1, 1, 2),
      --  KeyPadKeyClass("≥", 1, 1, 1),

    }
end



--------------------------------------------------------------------------- KeyPadPickerKeyPadClass
KeyPadSwitcherKeyPadClass = class(KeyPadClass)

function KeyPadSwitcherKeyPadClass:init(visible)
    KeyPadClass.init(self)

    self.keyColumns = 1

    self.keys = {
        KeyPadKeyClass("keypad", 1, 1, 2)
    }
end





-------------------------------------------------
-- Mouse input controls

function on.mouseUp(x,y)
	if PressedKeyPadKey ~= nil then
	    PressedKeyPadKey.highlighted = false
	end

	PressedKeyPadKey = nil

	platform.window:invalidate()
end

function on.mouseDown(x, y)
	for objectIndex, objectValue in ipairs(MainKeyPad.keys) do
	    if objectValue.visible and objectValue:containsPoint(x, y) then
	    	-- Reset the existing pressed key if there is one
	        if PressedKeyPadKey ~= nil then
	            PressedKeyPadKey.highlighted = false
	        end

	        -- Assign our newly found key as the pressed key globally
	        PressedKeyPadKey = objectValue
	        objectValue.highlighted = true

	        if objectValue.label == "reset" then
	                reset()
	            elseif objectValue.label == "del" then
	                deleter()
	                elseif objectValue.label == "enter" then
	                enter_event()
	                elseif objectValue.label == "keypad" then
	                    
	                   nextKeyPad()

	                else

                        input_actions(MainKeyPad, objectValue.label)
                end

	        platform.window:invalidate()

	        break
	    end
	end
end


function on.mouseMove(x,y)

    if TrackedObject ~= nil then
        if TrackedObject == KeyPadKeyClass then

            TrackedObject.x = x + TrackOffsetx
            TrackedObject.y = y + TrackOffsety
        end
    end

    platform.window:invalidate()
end

-------------------------------------------------
-- KeyBoard input controls

function on.charIn(char)

	--input_actions(MainKeyPad, char)
    Input = Input..char
    platform.window:invalidate()
end

function on.backspaceKey()
	--Display = Display:sub(0,-2)
	Input = Input:sub(0,-2)

	platform.window:invalidate()
end

 function on.escapeKey()
	reset()
 end

 function on.tabKey()
	if Show == 0 then
		Show = 1
	else
		Show = 0
	end
	platform.window:invalidate()
end

 function enter_event()
        resetKeyPads()
    if Show == 0 then
		Show = 1
	else
		Show = 0
	end
	platform.window:invalidate()
end

function on.enterKey()
    enter_event()
end

function on.arrowLeft()
    prevKeyPad()
    platform.window:invalidate()
end

function on.arrowRight()
    nextKeyPad()
    platform.window:invalidate()
end

function on.arrowUp()
    Size = Size + 1
end


function on.arrowDown()
    Size = Size - 1
end


---------------------------------------------------------- KeyPad Management

KeyPadRegistry = {
    KeyPadSwitcherKeyPadClass(true),
    NumericKeyPadClass(true),
    QwertyKeyPadClass(true),
}


function resetKeyPads()
    KeyPadIndex = 1
    MainKeyPad = KeyPadRegistry[KeyPadIndex]
    MainKeyPad:layoutKeys()
end


function nextKeyPad()
    KeyPadIndex = KeyPadIndex + 1
    if KeyPadIndex > #KeyPadRegistry then
        KeyPadIndex = 1
    end
    MainKeyPad = KeyPadRegistry[KeyPadIndex]
    MainKeyPad:layoutKeys()
end


function prevKeyPad()
    KeyPadIndex = KeyPadIndex - 1
    if KeyPadIndex < 1 then
        KeyPadIndex = #KeyPadRegistry
    end
    MainKeyPad = KeyPadRegistry[KeyPadIndex]
    MainKeyPad:layoutKeys()
end





-- Main Script

PressedKeyPadKey	= nil

function on.resize()
    reset()
end

function reset()
    resetKeyPads()
    Input = ""
    Output = ""
    Display = ""
    Result = ""
    Size = 12
    Show = 0
    platform.window:invalidate()
end


-----------------------------------
function on.paint(graphicsContext)

	local screenHeight = platform.window:height()
	local screenWidth = platform.window:width()

	graphicsContext:setColorRGB(230,230,255)
	graphicsContext:fillRect(0,0,screenWidth,screenHeight)
    
    
	MainKeyPad:paint(graphicsContext)
   -- graphicsContext:drawString(screenWidth, 10, 10)

    if KeyPadIndex == 1 then
        if screenWidth > 400 then
        Size = 32
        else
        Size = 14
        end
        displayht = screenHeight/3
        else
        if screenWidth > 400 then
        Size = 24
        else
        Size = 12
        end
        displayht = screenHeight/4
        end

	xvar = Input:find("x")
	test = Input:find("/")
	testpi = Display:find("π")
    gcd = 1
	num = Input
	den = 1
    Output = Display
    
-- Store left and right sides of equation for graphing

    testeq = Input:find("=")
    if testeq then
        fn1, fn2 = unpack(Input:split("="))
        var.store("fn1",fn1)
        var.store("fn2", fn2)
        else
        var.store("fn1",Input)
        var.store("fn2","")
    end

--Evaluate simple numeric fractions and correctly display algebraic fractions
    
	if test then
			num, den = unpack(Input:split("/"))


	if not xvar and not testpi then
	    var.store("input", Input)
	    Output = math.evalStr("expr(input)") or ""
	--[[	local gcd = math.eval("gcd("..num..","..den..")")

        if gcd then
			num = math.eval(num)/gcd
			den = den/gcd
			Output = num.."/"..den
      end]]
    end
   end

-- Evaluate simple numerical expressions (non-fraction)

    if not test and not xval then
	    var.store("input", Input)
	    Output = math.evalStr("expr(input)") or ""
    end

-- Solve simple polynomials


       if xvar then
       local div = "/"
        local testdv1 = Input:find(div)
        if not testdv1 then
            var.store("input",Input)
            
            Output = var.recall("output") or "("..num..")/("..den..")"
            --graphicsContext:drawString(Output,10,100)
        end
      end
    if xvar and not test then
    	  --  var.store("input", Input)
        Output = math.eval("String(PolyRoots("..Input..",x))")
       -- if Output then
       --     Output = Output:gsub(".,",",")
       --     Output = Output:gsub(".}","}")
       -- end
    end
    if not Output then
        Output = Display
     end

   	testop = tostring(Output):find("/")

    graphicsContext:setFont("serif","b",Size)
	graphicsContext:setColorRGB(20, 20, 158)

-- Correctly display as fractions or expressions

    Display = pretty(Input)
    Output = pretty(Output)

	if Show == 1 then
	    if test then
		fraction(screenWidth*0.4, displayht, Display, graphicsContext, 1)
		else
		sw = graphicsContext:getStringWidth(Display)
		graphicsContext:drawString(Display, screenWidth/2 - sw/2, displayht)
		end

		--graphicsContext:drawString("=", screenWidth/2, displayht)

		if testop and not xvar then
			graphicsContext:setColorRGB(150, 20, 20)
			fraction(screenWidth*0.4, 2*displayht, Output, graphicsContext, 1)
		else
			graphicsContext:setColorRGB(150, 20, 20)
		      sw = graphicsContext:getStringWidth(Output)
			graphicsContext:drawString(Output, screenWidth/2 - sw/2, 2*displayht)
		end
	else
	    if test then
		fraction(screenWidth*0.4, displayht, Display, graphicsContext, 1)
		else
		sw = graphicsContext:getStringWidth(Display)
		graphicsContext:drawString(Display, screenWidth/2 - sw/2, displayht)
        end
	end


	  graphicsContext:setFont("sansserif","b",8)
      graphicsContext:setColorRGB(255, 0, 255)

     str = "Enter a mathematical object by typing or keyPad; ESC to clear"
      sw = graphicsContext:getStringWidth(str)
      graphicsContext:drawString(str,screenWidth-sw - screenWidth / 50,screenHeight / 10)


--[[	if MainKeyPad.keyColumns then
	    graphicsContext:drawString(MainKeyPad.keyColumns, 10, 60)
	end
	graphicsContext:drawString(num, 10, 100)
    graphicsContext:drawString(den, 10, 140)
    --]]
end

