
function reset()
    W = platform.window:width()
    H = platform.window:height()
    Input = ""
    var.store("a", 0)
    var.store("b", 0)
    var.store("c", 0)
end

function on.resize()
    reset()
end

function on.charIn(char)
    Input = Input..char
    platform.window:invalidate()
end

function on.backspaceKey()
    Input = Input:sub(0, -2)
    platform.window:invalidate()
end

function on.escapeKey()
    reset()
end


function pretty(input)
        input = tostring(input)
        
        input = input:gsub("−", "-")
        
        input = input:gsub("%+%-", "-")
        input = input:gsub("%-%+", "-")
        input = input:gsub("%+%+", "+")
        input = input:gsub("%-%-", "+")
        
        input = input:gsub("0x%^3%+", "")
        input = input:gsub("0x%^3%-", "")
        input = input:gsub("0x%^2%+", "")
        input = input:gsub("0x%^2%-", "")
        input = input:gsub("0x%+", "")
        input = input:gsub("0x%-", "")
        input = input:gsub("%+0", "")
        input = input:gsub("%-0", "")
        input = input:gsub("1x", "x")
		input = input:gsub("%^2","²")
		input = input:gsub("%^9","⁹")
		input = input:gsub("%^8","⁸")
		input = input:gsub("%^7","⁷")
		input = input:gsub("%^6","⁶")
		input = input:gsub("%^5","⁵")
		input = input:gsub("%^4","⁴")
		input = input:gsub("%^3","³")
		input = input:gsub("%^1","¹")
		input = input:gsub("%^0","⁰")
        input = input:gsub("sqrt","√")
        input = input:gsub("\\","√(")
        input = input:gsub("÷","/")
        
        
        return input
end


function fraction(x, y, input, gc)

     local pre = input
     local post = ""
     local num = ""
     local den = ""
   

    local num, den = unpack(input:split("/"))
    
    if num and num ~= "" then
        pre = ""
        
        if num:find("%(") then
            pre, num = unpack(num:split("%("))
            num = num:sub(0, num:len() - 1)
        else
            while num:find("%+") do
            pre, num = unpack(num:split("%+"))
            pre = pre.."+"
            end
            while num:find("%-") do
            pre, num = unpack(num:split("%-"))
            pre = pre.."-"
            end
        end
    else
        pre = input
        num = ""
    end
    
    if den and den ~= "" then
        if den:find("%)") then
        den, post = unpack(den:split("%)"))
        _, den = unpack(den:split("%("))
        else
            while den:find("%+") do
            den, post = unpack(den:split("%+"))
            post = "+"..post
            end
            while den:find("%-") do
            den, post = unpack(den:split("%-"))
            post = "-"..post
            end
        end

    else
        den = ""
        post = ""
    end
    
    if den == "" then
        pre = num
        num = ""
        post = ""
    end

    local sw1 = math.max(gc:getStringWidth(num),gc:getStringWidth(den))
    local swpre =  1.1*gc:getStringWidth(pre)
    local swpost = 1.1*gc:getStringWidth(post)
    local total = sw1 + swpre + swpost

    gc:drawString(pre, x, y, "middle")
    gc:drawString(num, x + 1.1*swpre + (sw1 - gc:getStringWidth(num))/2, y, "bottom")

    gc:setPen("thin","smooth")
    gc:drawLine(x + 1.1*swpre, y, x + 1.1*swpre + sw1, y)

    gc:drawString(den, x + 1.1*swpre + (sw1 - gc:getStringWidth(den))/2, y, "top")
    gc:drawString(post, x + 1.1*(swpre + sw1), y, "middle")

	platform.window:invalidate()
end

function on.paint(gc)

    gc:setColorRGB(200, 200, 200)
    gc:fillRect(0, 0, W, H)
    
    a = (var.recall("a") or 0)
    b = (var.recall("b") or 0)
    c = (var.recall("c") or 0)
    
    if a ~= 0 or b ~= 0 or c ~= 0 then
    Input = a.."x^2+"..b.."x+"..c
    end
    
    
    Display = pretty(Input)

    if W > 318 then
        Size = 24
    else
        Size = 12
    end
    
    gc:setFont("sansserif", "b", Size+2)
    gc:setColorRGB(130, 20, 20)
    sw = gc:getStringWidth(Display)
    
    if Input:find("/") then
        fraction(W*0.4, H/4, Display, gc)
    else
        gc:drawString(Display, (W - sw)/2, H/4)
    end
    
    if not Input:find("/") and not Input:find("x") then
    	var.store("input", Input)
	    Output = math.evalStr("expr(input)") or ""        
    
    elseif Input:find("/") and not Input:find("x") then
    	var.store("input", Input)
	    Output = math.evalStr("expr(input)") or ""
	
    elseif Input:find("x") then
        Output = math.eval("String(PolyRoots("..Input..",x))")
    
    else
        Output = Display
    end
    
    if not Output then
        Output = ""
    end
    
    gc:setFont("sansserif", "b", Size)
    gc:setColorRGB(20, 20, 130)
    sw = gc:getStringWidth(Output)
    
    if Output:find("/") then
        fraction(W*0.4, 0.6*H, Output, gc)
    else
        gc:drawString(Output, (W - sw)/2, 0.6*H)
    end
    
    
    gc:setFont("sansserif", "r", Size*0.5)
    gc:setColorRGB(200, 20, 20)
    sw1 = gc:getStringWidth(Input)

    gc:drawString(Input, (W - sw1)/2, 0.9*H)
    
    
    
end