-- Copyright (C) 2011, Texas Instruments Incorporated
-- All rights reserved
-- Steve Arnold 2011-08-08
-- Builds and displays a dynamic display table within a Lua window.

 

function on.paint(gc)

--[[ This script picks up an existing variable called "lines" from the current document.
	It displays that number of lines using the settings given, which may be easily varied.
	
	This value determines the number of loops used to create each line of the table. each of these lines is then displayed using the settings shown.
	
	For example, in setFont, change "sansserif" to "serif", change "r" (regular) to "b" (bold) or "i" (italic).
	The final number gives the font size.
	
	setColor can be varied through the full range of RGB colors. Here we use burgundy.
	
	drawString then diplays each line centered on the window at equal intervals from top to bottom.
	
]]
	
    local screen = platform.window
    local w= screen:width() 
    local h= screen:height() 
    local table = {}

function on.paint(gc)
    w= screen:width() 
    h= screen:height() 
    local linecount = (var.recall("lines") or 1) 
    gc:setFont("sansserif", "r", 10) 
    gc:setColorRGB(158, 5, 8) 
 for k = 1, linecount do   
      table[k] = "Line #"..k 
      strwidth = gc:getStringWidth(table[k]) 
      strheight = gc:getStringHeight(table[k]) 
      gc:drawString(table[k], w/2 - strwidth/2 ,h*k/(linecount + 1) + strheight/2) 
  end 
end
