platform.apilevel = '1.0'
-- by Marc Garneau and Steve Arnold, 2012
-- This began as a simple version using counters to model integers, for the purpose of introducing classes in a workshop.
	-- Though now with a few enhancements

--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

--[[There are six sections in this script.
    
    1. INITialising everything and setting up reset and resize
    2. Setting up CLASSES (here we use rectangles and triangles)
    3. MOUSE controls
    4. KEYBOARD controls
    5. UTILITY functions: COUNT keeps track of everything and PRETTY makes the algebra look right. 
                            There is also a FACTOR routine and the About window is defined here.
    6. The PAINT function

    There is an optional seventh section which creates custom menus for changing the colors of the tile and more.

]]

-- SECTION 1: Begin be defining initial values and variables which will not change.

-- Add to this color list if desired
	Color = {
		red         = {255, 0, 0},
		orange      = {255, 165, 0},
		yellow      = {255, 255, 0},
		green       = {0, 255, 0},
		blue        = {0, 0, 255},
		white       = {255, 255, 255},
		black       = {0, 0, 0},
		paleblue    = {200, 200, 240},
		navy        = {20, 20, 138},
        maroon      = {170, 50, 50},
        gray        = {120, 120, 120},
        lightgray   = {200, 200, 200},
        salmon      = {235, 230, 230},

	}

-- Default tile colors
    poscolour=Color.paleblue
    negcolour=Color.white

function on.create()
   
   About = 1
   timer.start(10)
end

function on.activate()
    cursor.show()
 end

-- The resize function is called not only on resizing the page, but also on first opening the page.

function on.resize()

    cursor.show()


-- Set the window dimensions
	W = platform.window:width()
	H = platform.window:height()


-- TrackedObject will be the currently selected class object.
	TrackedObject = nil
    tabIndex = 1	
-- These offsets stop the object from jumping to its center when it is selected.
    TrackOffsetx = 0
    TrackOffsety = 0

-- The step size controls movement using arrow keys - the smaller the step, the longer it takes to get anywhere.
    Step = W/15
    
-- The default xvalue and unit
	Xval = 3
	Unit = Step
	
-- Turn is used to rotate x tiles: when 0, vertical, when 1, horizontal
	Turn = 0
	
-- Starting positions for the various tiles
	xstartpos = W*0.8
	xstartneg = xstartpos + 2*Unit
	ystartx2= H/4
	ystart1 = ystartx2 + 7*Unit
	ystartx= ystartx2 + 4*Unit

-- xmat is currently the width of the target mat
	xmat = 3*W/4

-- Initial tile values
    x2value = 0
    xvalue = 0
    value = 0
    factors = ""
    showFactors = 1
    factorsLabel = "(F)actors ON"
----------------------------------------
-- ** Set the alignment of your sliders here

Valign = "left"
--Halign = "bottom"

-- ** wide is the size of your circles and triangles
Wide = H/20


----------------------------------------
-- You should not need to change these...

    if Valign == "left" then
        Valn = 0.05*W
        Wpos = W - 2.5*Wide
    else
        Valn = 0.95*W
        Wpos = W - Valn + Wide
    end

   --[[ if Halign == "bottom" then
        Haln = 0.95*H
    else
        Haln = 0.05*H
    end]]
    
----------------------------------------

-- Mat creates the target mat which registers when objects are dragged onto it
    Mat = Rectangle(xmat/2, H/2, xmat, H, Color.white, "mat", 1, 0, "")

-- These triangles are used to change the value of x
    TriangleD = TriangleDown(Valn, 0.6*H + Wide, Wide)
    TriangleU = TriangleUp(Valn, 0.3*H, Wide)
    TriangleD1 = TriangleDown(Valn, 0.65*H + Wide, Wide*1.2)
    TriangleU1 = TriangleUp(Valn, 0.25*H, Wide*1.2)
        
-- These rectangles are not part of the Objects list of tiles and so are defined independently.

    Reset_Rectangle = Rectangle((xmat - W/10 + W/24)/2, H - H/20, xmat - W/12 - W/10, H/10, Color.salmon, "reset", 0, 0, "(R)eset")  
    Factors_Rectangle = Rectangle(xmat - W/10,H - H/20,W/5,H/10, Color.salmon, "factors", 0, 0, factorsLabel)  
    Help_Rectangle = Rectangle(W/24, H - H/20, W/12, H/10, Color.salmon, "help", 0, 0, "?")  

    About_Rectangle = Rectangle(W*0.5,H*0.5,W*0.8,H*0.9, Color.salmon, "about", 0, 0, "")  

-- The Objects list will get new generated counters, but starts with one of each type.
-- If you did not want the x squares or x tiles to appear, just remove them from this table.

    Objects = {
        Rectangle(xstartpos, ystartx, Unit, Xval*Unit, poscolour, "x", 1, 0, "x"),
		Rectangle(xstartpos, ystart1, Unit, Unit, poscolour, "1", 1, 0, "1"),
		Rectangle(xstartpos + Step, ystartx2 - Step, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"),
		Rectangle(xstartneg, ystartx, Unit, Xval*Unit, negcolour, "x", -1, 0, "-x"),
        Rectangle(xstartneg, ystart1, Unit, Unit, negcolour, "1", -1, 0, "-1"),
		Rectangle(xstartneg + Step, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"),
    }


--The count function checks the current status of all tiles and records those that lie within the Mat (see section 3).
    count()
    
	platform.window:invalidate()
	
end


--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

-- SECTION 2: Set up classes of rectangles and triangles.


Rectangle = class()

function Rectangle:init(x, y, width, height, color, type, value, orient, label)

    self.x = x
    self.y = y
    self.width = math.abs(width)
    self.height = math.abs(height)
    self.color = color 
    self.selected = false
    self.value = value
    self.orient = orient
    self.type = type
    self.label = label
end


function Rectangle:contains(x, y)
local orient = self.orient
local sw = orient==0 and self.width or self.height
local sh = orient==0 and self.height or self.width
return x >= self.x - sw/2 and x <= self.x + sw/2 and
       y >= self.y - sh/2 and y <= self.y + sh/2
end


function Rectangle:paint(gc)
local cx = self.x
local cy = self.y
local orient = self.orient
local color = self.color
local width = orient==0 and self.width or self.height
local height = orient==0 and self.height or self.width
local label = self.label or ""
local surround = self.value < 0 and "dashed" or "smooth"
gc:setPen("thin",surround)


gc:setColorRGB(unpack(color))
gc:fillRect(cx - width/2, cy - height/2, width, height)

local bordercolor = self.color == Color.salmon and Color.maroon or Color.black
gc:setColorRGB(unpack(bordercolor))
gc:drawRect(cx - width/2, cy - height/2, width, height)

        local fontSize = math.floor(W/32)
   	    local fontSize = math.floor(fontSize * 0.1)
	    local fontSize = fontSize > 6 and fontSize or 6
	    gc:setFont("sansserif","r",fontSize)	
        gc:setColorRGB(0, 0, 0)
        sw = gc:getStringWidth(label)
    
    if self.type == "x2" and self.value == -1 and self.x > xmat then
    gc:drawString(label, cx - sw/2 - width/4, cy - orient*height/4, "middle")
    else
        gc:drawString(label, cx - sw/2, cy - orient*height/4, "middle")

    end

    if self.selected then
    gc:setPen("medium","smooth")
    gc:drawRect(cx - width/2, cy - height/2, width, height)
end 
platform.window:invalidate()
end

-------------------------------------------------------------------------------------

TriangleUp = class()

function TriangleUp:init(x, y, size)

self.x = x
self.y = y
self.width = size
self.orient = orient
self.color = Color.salmon
self.selected = false
end


function TriangleUp:contains(x, y)

local sw = self.width
return x >= self.x - sw/2 and x <= self.x + sw/2 and
       y >= self.y and y <= self.y + sw
end


function TriangleUp:paint(gc)
local cx = self.x
local cy = self.y
local size = self.width
local vertices = {cx, cy, cx - size/2, cy + size, cx + size/2, cy + size, cx, cy}
gc:setColorRGB(unpack(Color.maroon))
gc:drawPolyLine(vertices)

gc:setColorRGB(unpack(self.color))
gc:fillPolygon(vertices)
if self.selected then
    gc:setPen("medium","smooth")
    gc:setColorRGB(0, 0, 0)
    gc:drawPolyLine(vertices)
end 
platform.window:invalidate()
end


TriangleDown = class()

function TriangleDown:init(x, y, size)

self.x = x
self.y = y
self.width = size
self.orient = orient
self.color = Color.salmon
self.selected = false
end


function TriangleDown:contains(x, y)

local sw = self.width
return x >= self.x - sw/2 and x <= self.x + sw/2 and
       y >= self.y - sw and y <= self.y
end


function TriangleDown:paint(gc)
local cx = self.x
local cy = self.y
local size = self.width
local vertices = {cx, cy, cx - size/2, cy - size, cx + size/2, cy - size, cx, cy}
gc:setColorRGB(unpack(Color.maroon))
gc:drawPolyLine(vertices)

gc:setColorRGB(unpack(self.color))
gc:fillPolygon(vertices)
if self.selected then
    gc:setPen("medium","smooth")
    gc:setColorRGB(0, 0, 0)
    gc:drawPolyLine(vertices)
end 
platform.window:invalidate()
end



--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

-- SECTION 3: Mouse controls

function on.mouseDown(x,y)

        for i = #Objects, 1, -1 do
		    local obj = Objects[i]
            obj.selected = false
        end
        
    if About > 0 then
        About = (About + 1) % 3
        platform.window:invalidate()
    end        
        if Reset_Rectangle:contains(x, y) then
		   Reset_Rectangle.selected = true
		platform.window:invalidate()
        end

       if Help_Rectangle:contains(x, y) then
		   Help_Rectangle.selected = true
		platform.window:invalidate()
        end

      if Factors_Rectangle:contains(x, y) then
		   Factors_Rectangle.selected = true
		platform.window:invalidate()
        end
    

    if TriangleU1:contains(x,y) then
        TriangleU1.selected = true
        platform.window:invalidate()
     end       
     if TriangleD1:contains(x,y) then
         if Xval >= 1 then
                TriangleD1.selected = true
         end
                platform.window:invalidate()
      end          
    if TriangleU:contains(x,y) then
        TriangleU.selected = true
        platform.window:invalidate()
     end       
     if TriangleD:contains(x,y) then
         if Xval >= 0.1 then
                TriangleD.selected = true
         end
                platform.window:invalidate()
      end          

    for i = #Objects, 1, -1 do
		local obj = Objects[i]
		
		if obj:contains(x, y) then
			TrackedObject = obj
			obj.selected = true
            cursor.set("drag grab")
			TrackOffsetx = TrackedObject.x - x
			TrackOffsety = TrackedObject.y - y
			platform.window:invalidate()

 		if Mat:contains(obj.x, obj.y)  then
			if obj.type == "x" or obj.type == "-x"  then
                if Turn == 1 or not Rectangle(obj.x, obj.y, Unit, Unit, poscolour, "1", 1, "x"):contains(x,y) or not Rectangle(obj.x, obj.y, Unit, Unit, negcolour, "1", 1, "-x"):contains(x,y) then
                obj.orient = math.abs(obj.orient - 1)
                cursor.set("rotation")
                Turn = 0
                end
            end
        end
			
-- this is the coolest part; if I grab a counter from the right, it will create a new one to replenish the supply!

 		if not Mat:contains(obj.x, obj.y)  then
                if obj.value == -1 and obj.type == "1" then
					table.insert(Objects, Rectangle(xstartneg, ystart1, Unit, Unit, negcolour,"1", -1, 0, "-1"))
				elseif obj.value == 1 and obj.type == "1" then
					table.insert(Objects, Rectangle(xstartpos, ystart1, Unit, Unit, poscolour, "1", 1, 0, "1"))
				elseif obj.value == -1 and obj.type == "x" then
					table.insert(Objects, Rectangle(xstartneg, ystartx, Unit, Xval*Unit, negcolour, "x", -1, 0, "-x"))
				elseif obj.value == 1 and obj.type == "x" then
                    table.insert(Objects, Rectangle(obj.x, obj.y,  Unit, Xval*Unit, poscolour, "x", 1, 0, "x"))
				elseif obj.value == -1 and obj.type == "x2" then
					table.insert(Objects, Rectangle(xstartneg + Unit, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"))
                elseif obj.value == 1 and obj.type == "x2" then
					table.insert(Objects, Rectangle(xstartpos + Unit, ystartx2 - Unit, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"))
            end
			break
		end
-- this avoids the object jumping to centre when you don't put the mouse down in the centre

            cursor.set("drag grab")
			TrackOffsetx = TrackedObject.x - x
			TrackOffsety = TrackedObject.y - y
			platform.window:invalidate()
			break
		end

	end
end

function on.mouseUp(x,y)

	if cursor.set("drag grab") then
		cursor.set("hand open")
		else
		cursor.set("default")
    end

    if Reset_Rectangle.selected then
	        Reset_Rectangle.selected = false
	    	TrackedObject = nil
            on.resize()
	end
	
	if Help_Rectangle.selected then
	        Help_Rectangle.selected = false
	    	TrackedObject = nil	    
    		About = (About + 1) % 3
            platform.window:invalidate()
    end	

	if Factors_Rectangle.selected then
    	    Factors_Rectangle.selected = false
	    	TrackedObject = nil
            if showFactors == 0 then
                showFactors = 1
                Factors_Rectangle.label = "(F)actors ON"
            else
                showFactors = 0
                Factors_Rectangle.label = "(F)actors OFF"
            end
            platform.window:invalidate()
    end

		
	if TrackedObject ~= nil then
 		if Mat:contains(TrackedObject.x, TrackedObject.y)  then
            
            for i = #Objects, 1, -1 do
        		local obj = Objects[i]
        		if TrackedObject == obj then
                    for j = #Objects, 1, -1 do
        	        	local obj1 = Objects[j]
                        if obj1 and obj1:contains(obj.x, obj.y) and obj.type == obj1.type and obj1.value == obj.value*-1 then
        	        	if Mat:contains(obj1.x, obj1.y) then
                            if i > j then
                            table.remove(Objects, i)
                            table.remove(Objects, j)
                            else
                            table.remove(Objects, j)
                            table.remove(Objects, i)
                            end
                        end
                        end
                    end
                end
            end
        end
     end


	if TriangleU.selected then
                Xval = Xval + 0.1
                
        for i = #Objects, 1, -1 do
    		local obj = Objects[i]
              obj.height = obj.height + 0.1*Unit
            if obj.type == "x2" then
                obj.width = obj.height
            elseif obj.type == "1" then
                obj.height = Unit
                obj.width = Unit
            end
        end
                TriangleU.selected = false
                platform.window:invalidate()
    end 
         
    if TriangleU1.selected then
                Xval = Xval + 1
                
        for i = #Objects, 1, -1 do
		    local obj = Objects[i]
              obj.height = obj.height + Unit
            if obj.type == "x2" then
                obj.width = obj.height
            elseif obj.type == "1" then
                obj.height = Unit
                obj.width = Unit
           end
        end
                TriangleU1.selected = false 
                platform.window:invalidate()
    end 
         
   if TriangleD.selected then
            if Xval >= 0.1 then
                Xval = Xval - 0.1
            end
            if Xval < 0.1 then
                Xval = 0
            end
            
                TriangleD.selected = false
                
            for i = #Objects, 1, -1 do
		        local obj = Objects[i]
                obj.height = obj.height >= 0 and obj.height - 0.1*Unit or 0.1*Unit
                if obj.type == "x2" then
                    obj.width = obj.height
                elseif obj.type == "1" then
                    obj.height = Unit
                    obj.width = Unit
                end
            end
                platform.window:invalidate()
   end

   if TriangleD1.selected then
            if Xval >= 1 then
                Xval = Xval - 1
            end
                TriangleD1.selected = false
                
            for i = #Objects, 1, -1 do
		        local obj = Objects[i]
                obj.height = obj.height >= 0 and obj.height - Unit or Unit
                if obj.type == "x2" then
                    obj.width = obj.height
                elseif obj.type == "1" then
                    obj.height = Unit
                    obj.width = Unit
                end
            end
                platform.window:invalidate()
    end

	if TrackedObject ~= nil then

-- This forces the selected object on release to align with an invisible grid, half a unit in size.

    	TrackedObject.x = math.floor(TrackedObject.x/(Unit*0.5))*0.5*Unit
    	TrackedObject.y = math.floor(TrackedObject.y/(Unit*0.5))*0.5*Unit
	
	  --  TrackedObject.selected = false
	end
	
	TrackedObject = nil
	platform.window:invalidate()
end


function on.mouseMove(x,y)
--[[	if TrackedObject ~= nil then
-- This stops the selected object from jumping to the center on mouse click.
		TrackedObject.x = x + TrackOffsetx
		TrackedObject.y = y + TrackOffsety
	end]]
	
	count()

    for i = #Objects, 1, -1 do
		local obj = Objects[i]
		if obj:contains(x, y) then
		
		-- If an object is on the mat, then the cursor shows differently for the x-tiles.
		  if Mat:contains(obj.x, obj.y)  then
			if obj.type == "x" or obj.type == "-x"  then
                if Turn == 1 or not Rectangle(obj.x, obj.y, Unit, Unit, poscolour, "1", 1, "x"):contains(x,y) or not Rectangle(obj.x, obj.y, Unit, Unit, negcolour, "1", 1, "-x"):contains(x,y) then
                cursor.set("rotation")
			    platform.window:invalidate()
			    break
                                else
			    cursor.set("hand open")
			    platform.window:invalidate()
			    break
                end
            else
			cursor.set("hand open")
			platform.window:invalidate()
			break
		    end
        else
			cursor.set("hand open")
			platform.window:invalidate()
			break

            end
 		else
			cursor.set("default")
		end
	end
	if TrackedObject ~= nil then
		cursor.set("drag grab")
		TrackedObject.x = x + TrackOffsetx
		TrackedObject.y = y + TrackOffsety
		platform.window:invalidate()
	end
end

--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

-- SECTION 4: Keyboard controls

-- The tab key runs through each item in the Objects table, while shift-tab runs in reverse order..

function on.backtabKey()

           if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        tabIndex = tabIndex - 1
		        if tabIndex < 1  then
		            tabIndex = #Objects
		        end
		    end
   
	            TrackedObject = Objects[tabIndex]
 		    
			TrackedObject.selected = true
			platform.window:invalidate()
			
end

function on.tabKey()

           if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        tabIndex = tabIndex + 1
		        if tabIndex > #Objects then
		            tabIndex = 1
		        end
		    end
   
	            TrackedObject = Objects[tabIndex]
 		    
			TrackedObject.selected = true
			
			platform.window:invalidate()
			
end

-- Notice that the size of each step is controlled by the initial variable Step.
-- Using the arrow keys on a tile in starting position will clone that object.

function on.arrowRight()

   if TrackedObject ~= nil then

          if TrackedObject.x == xstartpos or TrackedObject.x == xstartneg or TrackedObject.x == xstartpos + Unit or TrackedObject.x == xstartneg + Unit then

				if TrackedObject.value == -1  and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartneg, ystart1, Unit, Unit, negcolour, "1", -1, 0, "-1"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartpos, ystart1, Unit, Unit, poscolour, "1",  1, 0, "1"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartneg, ystartx,  Unit, Xval*Unit, negcolour, "x", -1, Turn, "-x"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartpos, ystartx,  Unit, Xval*Unit, poscolour, "x", 1, Turn, "x"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x2" then
					table.insert(Objects, Rectangle(xstartneg + Unit, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"))
                else
					table.insert(Objects, Rectangle(xstartpos + Unit, ystartx2 - Unit, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"))
            end
            end
            
 		if Mat:contains(TrackedObject.x, TrackedObject.y)  then
            
            for i = #Objects, 1, -1 do
        		local obj = Objects[i]
        		if TrackedObject == obj then
                    for j = #Objects, 1, -1 do
        	        	local obj1 = Objects[j]
                        if obj1 and obj1:contains(obj.x, obj.y) and obj.type == obj1.type and obj1.value == obj.value*-1 then
        	        	if Mat:contains(obj1.x, obj1.y) then
                            if i > j then
                            table.remove(Objects, i)
                            table.remove(Objects, j)
                            else
                            table.remove(Objects, j)
                            table.remove(Objects, i)
                            end
                        end
                        end
                    end
                end
            end
        end

    if TrackedObject.x > TrackedObject.width / 2 then
        TrackedObject.x = TrackedObject.x + Step
    end
    end
    	count()
     	platform.window:invalidate()

end

function on.arrowLeft()

    if TrackedObject ~= nil then

            if TrackedObject.x == xstartpos or TrackedObject.x == xstartneg or TrackedObject.x == xstartpos + Unit or TrackedObject.x == xstartneg + Unit then

				if TrackedObject.value == -1  and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartneg, ystart1, Unit, Unit, negcolour, "1", -1, 0, "-1"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartpos, ystart1, Unit, Unit, poscolour, "1",  1, 0, "1"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartneg, ystartx,  Unit, Xval*Unit, negcolour, "x", -1, Turn, "-x"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartpos, ystartx,  Unit, Xval*Unit, poscolour, "x", 1, Turn, "x"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x2" then
					table.insert(Objects, Rectangle(xstartneg + Unit, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"))
                else
					table.insert(Objects, Rectangle(xstartpos + Unit, ystartx2 - Unit, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"))
            end
            end
            
 		if Mat:contains(TrackedObject.x, TrackedObject.y)  then
            
            for i = #Objects, 1, -1 do
        		local obj = Objects[i]
        		if TrackedObject == obj then
                    for j = #Objects, 1, -1 do
        	        	local obj1 = Objects[j]
                        if obj1 and obj1:contains(obj.x, obj.y) and obj.type == obj1.type and obj1.value == obj.value*-1 then
        	        	if Mat:contains(obj1.x, obj1.y) then
                            if i > j then
                            table.remove(Objects, i)
                            table.remove(Objects, j)
                            else
                            table.remove(Objects, j)
                            table.remove(Objects, i)
                            end
                        end
                        end
                    end
                end
            end
        end

    if TrackedObject.x > TrackedObject.width / 2 then
        TrackedObject.x = TrackedObject.x - Step
    end
    end
    	count()
     	platform.window:invalidate()
 
 
end


function on.arrowDown()

    if TrackedObject ~= nil then
    
          if TrackedObject.x == xstartpos or TrackedObject.x == xstartneg or TrackedObject.x == xstartpos + Unit or TrackedObject.x == xstartneg + Unit then

				if TrackedObject.value == -1  and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartneg, ystart1, Unit, Unit, negcolour, "1", -1, 0, "-1"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartpos, ystart1, Unit, Unit, poscolour, "1",  1, 0, "1"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartneg, ystartx,  Unit, Xval*Unit, negcolour, "x", -1, Turn, "-x"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartpos, ystartx,  Unit, Xval*Unit, poscolour, "x", 1, Turn, "x"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x2" then
					table.insert(Objects, Rectangle(xstartneg + Unit, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"))
                else
					table.insert(Objects, Rectangle(xstartpos + Unit, ystartx2 - Unit, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"))
            end
            end
            
 		if Mat:contains(TrackedObject.x, TrackedObject.y)  then
            
            for i = #Objects, 1, -1 do
        		local obj = Objects[i]
        		if TrackedObject == obj then
                    for j = #Objects, 1, -1 do
        	        	local obj1 = Objects[j]
                        if obj1 and obj1:contains(obj.x, obj.y) and obj.type == obj1.type and obj1.value == obj.value*-1 then
        	        	if Mat:contains(obj1.x, obj1.y) then
                            if i > j then
                            table.remove(Objects, i)
                            table.remove(Objects, j)
                            else
                            table.remove(Objects, j)
                            table.remove(Objects, i)
                            end
                        end
                        end
                    end
                end
            end
        end

    if TrackedObject.y > TrackedObject.width / 2 then
        TrackedObject.y = TrackedObject.y + Step
    end
    end
    	count()
     	platform.window:invalidate()

end

function on.arrowUp()

   if TrackedObject ~= nil then
          if TrackedObject.x == xstartpos or TrackedObject.x == xstartneg or TrackedObject.x == xstartpos + Unit or TrackedObject.x == xstartneg + Unit then

				if TrackedObject.value == -1  and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartneg, ystart1, Unit, Unit, negcolour, "1", -1, 0, "-1"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "1"  then
					table.insert(Objects, Rectangle(ustartpos, ystart1, Unit, Unit, poscolour, "1",  1, 0, "1"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartneg, ystartx,  Unit, Xval*Unit, negcolour, "x", -1, Turn, "-x"))
				elseif TrackedObject.value == 1 and TrackedObject.type == "x" then
					table.insert(Objects, Rectangle(xstartpos, ystartx,  Unit, Xval*Unit, poscolour, "x", 1, Turn, "x"))
				elseif TrackedObject.value == -1 and TrackedObject.type == "x2" then
					table.insert(Objects, Rectangle(xstartneg + Unit, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"))
                else
					table.insert(Objects, Rectangle(xstartpos + Unit, ystartx2 - Unit, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"))
            end
            end
            
 		if Mat:contains(TrackedObject.x, TrackedObject.y)  then
            
            for i = #Objects, 1, -1 do
        		local obj = Objects[i]
        		if TrackedObject == obj then
                    for j = #Objects, 1, -1 do
        	        	local obj1 = Objects[j]
                        if obj1 and obj1:contains(obj.x, obj.y) and obj.type == obj1.type and obj1.value == obj.value*-1 then
        	        	if Mat:contains(obj1.x, obj1.y) then
                            if i > j then
                            table.remove(Objects, i)
                            table.remove(Objects, j)
                            else
                            table.remove(Objects, j)
                            table.remove(Objects, i)
                            end
                        end
                        end
                    end
                end
            end
        end

    if TrackedObject.y > TrackedObject.width / 2 then
        TrackedObject.y = TrackedObject.y - Step
    end
    end
    	count()
     	platform.window:invalidate()

end





-- charIn recognises a variety of letters for different purposes.

function on.charIn(char)


        for i = #Objects, 1, -1 do
		    local obj = Objects[i]
            obj.selected = false
        end
        
     if char == "+" or char == "n" or char == "N" or char == "-" or char == "−"  then
                    oldchar = char
   
    elseif char == "a" or char == "?" then
		About = (About + 1) % 3
		platform.window:invalidate()

    elseif char == "f" or char == "F" then
        if showFactors == 0 then
        showFactors = 1
        Factors_Rectangle.label = "(F)actors ON"
        else
        showFactors = 0
        Factors_Rectangle.label = "(F)actors OFF"
        end
        platform.window:invalidate()

    elseif char == "c" or char == "C" or char == "r" or char == "R"  then
        on.resize()
        platform.window:invalidate()
        
	elseif char=="t" or char=="T" then
		Turn = 1
		if TrackedObject ~= nil then
					if TrackedObject.type == "x" or TrackedObject.type == "-x"  then
                TrackedObject.orient = math.abs(TrackedObject.orient - 1)
                Turn = 0
            end
        end
        
    
    -- This next section selects the object named.
    -- First checks and remembers if "n" is typed (negative)
    
    
    elseif char == "x" or char == "X" then

                if oldchar == "n" or oldchar == "N" or oldchar == "-" or oldchar == "−"  then
					table.insert(Objects, Rectangle(xstartneg, ystartx,  Unit, Xval*Unit, negcolour, "x", -1, Turn, "-x"))
                    Objects[#Objects].selected = true
                    TrackedObject = Objects[#Objects]
                    oldchar = ""
                else
                    table.insert(Objects, Rectangle(xstartpos, ystartx,  Unit, Xval*Unit, poscolour, "x", 1, Turn, "x"))
                    Objects[#Objects].selected = true
                    TrackedObject = Objects[#Objects]
                    oldchar = ""
                end 

           
        elseif char == "u" or char == "U" or char == "1" and oldchar ~= "+" then

                if oldchar == "n" or oldchar == "N" or oldchar == "-" or oldchar == "−"  then
					table.insert(Objects, Rectangle(xstartneg, ystart1, Unit, Unit, negcolour, "1", -1, 0, "-1"))
                    Objects[#Objects].selected = true
                    TrackedObject = Objects[#Objects]
                    oldchar = ""
                else
					table.insert(Objects, Rectangle(xstartpos, ystart1, Unit, Unit, poscolour, "1", 1, 0, "1"))
                    Objects[#Objects].selected = true
                    TrackedObject = Objects[#Objects]
                    oldchar = ""
                end  

        elseif char == "s" or char == "S" then

                if oldchar == "n" or oldchar == "N" or oldchar == "-" or oldchar == "−" then
					table.insert(Objects, Rectangle(xstartneg + Unit, ystartx2, Xval*Unit, Xval*Unit, negcolour, "x2", -1, 0, "-x²"))
                    Objects[#Objects].selected = true
                    TrackedObject = Objects[#Objects]
                    oldchar = ""
                else
					table.insert(Objects, Rectangle(xstartpos + Unit, ystartx2 - Unit, Xval*Unit, Xval*Unit, poscolour, "x2", 1, 0, "x²"))
                    Objects[#Objects].selected = true
                    TrackedObject = Objects[#Objects]
                    oldchar = ""
                end  

        -- This checks if the entered character is a number.
        
     elseif  oldchar == "+" and char:find("%d") and tonumber(char) >= 0 then
     
       Xval = char
        oldchar = ""
        
    for i = #Objects, 1, -1 do
		local obj = Objects[i]
          obj.height = char*Unit
        if obj.type == "x2" then
            obj.width = char*Unit
        elseif obj.type == "1" then
            obj.height = Unit
            obj.width = Unit
        end

    end
    elseif char == ">" then
     
       Xval = Xval + 0.1
                
    for i = #Objects, 1, -1 do
		local obj = Objects[i]
          obj.height = obj.height+Unit*0.1
        if obj.type == "x2" then
            obj.width = obj.width+Unit*0.1
        elseif obj.type == "1" then
            obj.height = Unit
            obj.width = Unit
        end

    end
    elseif char == "<" and tonumber(Xval) > 0 then
     
       Xval = tonumber(Xval) - 0.1
                
    for i = #Objects, 1, -1 do
		local obj = Objects[i]
          obj.height = obj.height-Unit*0.1
        if obj.type == "x2" then
            obj.width = obj.width-Unit*0.1
        elseif obj.type == "1" then
            obj.height = Unit
            obj.width = Unit
        end

    end
    end

    platform.window:invalidate()
end

function on.backspaceKey()

        for i = #Objects, 1, -1 do
		    local obj = Objects[i]
            if obj.selected == true then
                table.remove(Objects, i)
            end
        end
        count()
        platform.window:invalidate()
end

-- use escape key to release the selected object

function on.escapeKey()
		About = 0
		platform.window:invalidate()
        
        for i = #Objects, 1, -1 do
		    local obj = Objects[i]
            obj.selected = false
        end

end


function on.enterKey()
		About = 0
		platform.window:invalidate()
        
        for i = #Objects, 1, -1 do
		    local obj = Objects[i]
            obj.selected = false
        end

end

--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

-- SECTION 5: UTILITY functions
-- The count function: keeping track of things

function count()
	value = 0
	xvalue = 0
	x2value = 0
	pos = 0
	neg = 0
	xpos = 0
	xneg = 0
	x2pos = 0
	x2neg = 0
	
	for i = 1, #Objects do
		local obj = Objects[i]
		
		if Mat:contains(obj.x, obj.y)  then
	    
			if obj.value == 1 and obj.type == "1" then
				value = value + 1
			end
			if obj.value == -1 and obj.type == "1"  then
				value = value - 1
			end
			if obj.value == 1 and obj.type == "x" then
				xvalue = xvalue + 1
			end
			if obj.value == -1 and obj.type == "x"  then
				xvalue = xvalue - 1
			end
			if obj.value == 1 and obj.type == "x2" then
				x2value = x2value + 1
			end
			if obj.value == -1 and obj.type == "x2"  then
				x2value = x2value - 1
			end


		end
	end
	var.store("a",x2value)
	var.store("b",xvalue)
	var.store("c", value)
	
	factor(x2value, xvalue, value)

end

-- This is the factor function

function factor(a, b, c)
	factors = ""
		
	if a < 0 then
	cf = -1
	a = -1*a
	b = -1*b
	c = -1*c
	else
	cf = 1
	end
	
	local ac = a*c
	
    if math.abs(a) > 0  and math.abs(c) > 0 and b == 0 then
    
        local cf1 = math.eval("gcd("..a..","..c..")")
        local a = a/cf1
        local c = c/cf1
        
        if c < 0 then
          c = math.abs(c)
          
        if math.floor(math.sqrt(c)) == math.sqrt(c) then
            
            factors = pretty(cf*cf1.."(x-"..math.sqrt(c)..")(x+"..math.sqrt(c)..")")
            
        end
        
        end
        
	elseif math.abs(a) > 0 and math.abs(c) > 0 and math.abs(b) > 0 then
	
	for k = 1, math.floor(math.sqrt(math.abs(ac))) do
	
	    local factor1 = math.floor(ac/k) == ac/k and ac/k or ac
	   
	    if factor1 + k == b then
	    
	        m = factor1
	        n = k

    if m and n then
       if m + n ~= b or m*n ~= ac then
	    
	    m = nil
	    n = nil
	    else
	    break
	    end
    end
	    
	    elseif factor1 - k == b then
	    
	        m = factor1
	        n = -1*k
	    
    if m and n then
       if m + n ~= b or m*n ~= ac then
	    
	    m = nil
	    n = nil
	    else
	    break
	    end
    end
	    
	elseif k - factor1 == b then
	   
	        m = -1*factor1
	        n = k
	   
    if m and n then
       if m + n ~= b or m*n ~= ac then
	    
	    m = nil
	    n = nil
	    else
	    break
	    end
    end
	    
	 elseif -1*k - factor1 == b then
	   
	    m = -1*factor1
	    n = -1*k
	   
    if m and n then
       if m + n ~= b or m*n ~= ac then
	    
	    m = nil
	    n = nil
	    else
	    break
	    end
    end
    
	else
	    m = nil
	    n = nil
	    
	    end
    end
    
    
    if m and n then
	    local cf1 = math.eval("gcd("..a..","..m..")") or 1
	    local cf2 = math.eval("gcd("..n..","..c..")") or 1
	    local cf3 = math.eval("gcd("..cf1..","..cf2..")") or 1
	    local cf1 = cf1/cf3
	    local cf2 = cf2/cf3
	    local a = a/cf1
	    local m = m/cf1
	    local c = c/cf2
	    local n = n/cf2
	    local cf4 = math.eval("gcd("..n..","..c..")") or 1
	    local c = c/cf4
	    local n = n/cf4
	    if n < 0 then
	        c = -1*c
	        n = -1*n
	        cf2 =-1*cf2
	    end
	    
	    if cf*cf3*cf4 == 1 then
	        factors = pretty("("..cf1.."x+"..cf2..")("..n.."x+"..c..")")
	       -- factors = "m = "..m.." and n = "..n
        else
            factors = pretty(cf*cf3.."("..cf1.."x+"..cf2..")("..n.."x+"..c..")")
	      --  factors = "m = "..m.." and n = "..n
        end
        else
            factors = ""
        end

    elseif math.abs(a) > 0  and math.abs(b) > 0 and math.abs(c) == 0  then
    
 	    local cf1 = math.eval("gcd("..a..","..b..")") or 1
 	    local a = a/cf1
 	    local b = b/cf1
 	    
        if cf1 == 1 then
        factors = pretty("x("..a.."x+"..b..")")
        else
        factors = pretty(cf1.."x("..a.."x+"..b..")")
        end
        
     
     elseif a == 0 and math.abs(b) > 0 and math.abs(c) > 0 then
        
        local cf1 = math.eval("gcd("..b..","..c..")") or 1
 	    local c = c/cf1
 	    local b = b/cf1
 	    
        if cf1 == 1 then
        factors = ""
        else
        factors = pretty(cf1.."("..b.."x+"..c..")")
        end

         else
            factors = ""
        end
       
end


-- This pretty prints the algebraic form
-- The % symbols tell Lua to ignore these special characters (which normally do other jobs)

function pretty(input)
        input = tostring(input)
        
        input = input:gsub("−", "-")
        
        input = input:gsub("%+%-", "-")
        input = input:gsub("%-%+", "-")
        input = input:gsub("%+%+", "+")
        input = input:gsub("%-%-", "+")
        
        input = input:gsub("0x%^3%+", "")
        input = input:gsub("0x%^3%-", "-")
        input = input:gsub("0x%^2%+", "")
        input = input:gsub("0x%^2%-", "-")
        input = input:gsub("0x²%+", "")
        input = input:gsub("0x²%-", "-")
        input = input:gsub("0x%+", "")
        input = input:gsub("0x%-", "-")
        input = input:gsub("%+0", "")
        input = input:gsub("%-0", "")
        input = input:gsub("1x", "x")
        input = input:gsub("1%(", "(")
		input = input:gsub("%^2","²")
		input = input:gsub("%^9","⁹")
		input = input:gsub("%^8","⁸")
		input = input:gsub("%^7","⁷")
		input = input:gsub("%^6","⁶")
		input = input:gsub("%^5","⁵")
		input = input:gsub("%^4","⁴")
		input = input:gsub("%^3","³")
		input = input:gsub("%^1","¹")
		input = input:gsub("%^0","⁰")
        input = input:gsub("sqrt","√")
        input = input:gsub("\\","√(")
        input = input:gsub("÷","/")
        input = input:gsub("%+%-", "-")
        input = input:gsub("%-%+", "-")
        input = input:gsub("%+%+", "+")
        input = input:gsub("%-%-", "+")
        input = input:gsub("%.%,", ",")
        input = input:gsub("%.%}", "}")
                
        return input
end


--------------------------------------------------------------------------------------

-- Defining the About Screen

function aboutScreen(gc)

    About_Rectangle:paint(gc)
    gc:setColorRGB(unpack(Color.navy))
	
    border(W*0.5, H*0.5, W*0.8, H*0.9, "thick", 50, gc)
    local lines = 9
    
        local fontSize = math.floor(W/32)
   	    local fontSize = math.floor(fontSize)
	    local fontSize = fontSize > 6 and fontSize or 6

	gc:setFont("sansserif","b",fontSize)	
    gc:setColorRGB(unpack(Color.maroon))
    strwidth = gc:getStringWidth("Algebra Tiles v.04.2012")
	strheight = gc:getStringHeight("Algebra Tiles v.04.2012")
    gc:drawString("Algebra Tiles v.04.2012",W/2-strwidth/2,H*0.15-strheight/2,"middle")

    if About == 1 then
        local fontSize = math.floor(W/32)
   	    local fontSize = math.floor(fontSize * 0.2)
	    local fontSize = fontSize > 6 and fontSize or 6
	gc:setFont("sansserif","r",fontSize)	
	gc:setColorRGB(unpack(Color.navy))

	gc:drawString('Build algebraic expressions by dragging tiles onto the mat.',W*0.115,H*(0.2 + 1/(lines+1)),"middle")
	gc:drawString("Drag the x-tiles by grabbing the center; turn them",W*0.115,H*(0.2 + 2/(lines+1)),"middle")
	gc:drawString('by clicking on either end (or press "T" when selected).',W*0.115,H*(0.2 + 3/(lines+1)),"middle")
	gc:drawString('Escape will de-select and "R" will Reset all.',W*0.115,H*(0.2 + 4/(lines+1)),"middle")
	gc:drawString('Set x-value by typing +1,+2, etc. Increment using < and >.',W*0.115,H*(0.2 + 5/(lines+1)),"middle")

	gc:setFont("sansserif","i",fontSize)	
	gc:setColorRGB(unpack(Color.maroon))
    gc:drawString('Tip: Drop tiles just below and to the right to place them.',W*0.115,H*(0.2 + 6/(lines+1)),"middle")

    strwidth = gc:getStringWidth('Press escape to exit or click to continue.')
    gc:drawString('Press escape to exit or click to continue.',W/2-strwidth/2,H*(0.2 + 7/(lines+1)),"middle")
	
	elseif About == 2 then
        local fontSize = math.floor(W/32)
   	    local fontSize = math.floor(fontSize * 0.2)
	    local fontSize = fontSize > 6 and fontSize or 6
	gc:setFont("sansserif","r",fontSize)	
	gc:setColorRGB(unpack(Color.navy))
	
	gc:drawString('You may also press "X" to select an x-tile,',W*0.115,H*(0.2 + 1/(lines+1)),"middle")
	gc:drawString('press "S" for x-squared, and for a unit tile press "1".', W*0.115, H*(0.2 + 2/(lines+1)),"middle")
	gc:drawString('For negatives, first press "-" then the desired tile.',W*0.115,H*(0.2 + 3/(lines+1)),"middle")
	gc:drawString("tab and shift-tab may also be used to select tiles.",W*0.115,H*(0.2 + 4/(lines+1)),"middle")
	gc:setFont("sansserif","i",fontSize)	
	gc:setColorRGB(unpack(Color.maroon))
	gc:drawString("Tip: Try selecting using a letter, then move your mouse.",W*0.115,H*(0.2 + 5/(lines+1)),"middle")
	gc:setFont("sansserif","r",fontSize)	
	gc:setColorRGB(unpack(Color.navy))
		gc:drawString('Press "F" or the Factors button to see the factored form.',W*0.115,H*(0.2 + 6/(lines+1)),"middle")
	gc:setColorRGB(unpack(Color.maroon))
	
    strwidth = gc:getStringWidth('Press escape or click to continue.')
    gc:drawString('Press escape or click to exit.',W/2-strwidth/2,H*(0.2 + 7/(lines+1)),"middle")

    end

  
end


-- Nice border for About Screen and other buttons

function border(x, y, width, height, style, curve, graphicsContext)
    
    graphicsContext:setPen(style, "smooth")
	
	graphicsContext:drawLine(x - 0.975*width/2, y - height/2, x + 0.975*width/2, y - height/2)
	graphicsContext:drawLine(x - 0.975*width/2, y + height/2, x + 0.975*width/2, y + height/2)
	graphicsContext:drawLine(x - width/2, y - 0.975*height/2, x - width/2, y + 0.975*height/2)
	graphicsContext:drawLine(x + width/2, y - 0.975*height/2, x + width/2, y + 0.975*height/2)

    graphicsContext:drawArc(x - width/2, y - height/2, width/curve, width/curve, -180, -90)
	graphicsContext:drawArc(x + 0.962*width/2, y - height/2, width/curve, width/curve, 0, 90)
	graphicsContext:drawArc(x + 0.962*width/2, y + 0.95*height/2, width/curve, width/curve, -90, 90)
	graphicsContext:drawArc(x - width/2, y + 0.95*height/2, width/curve, width/curve, -180, 90)


end

--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

-- SECTION 6: Painting it all to the screen



function on.paint(gc)

-- First set up the static background

-- Set the window dimensions
	W = platform.window:width()
	H = platform.window:height()
	


    Rectangle(0.8*W, H/2, 0.4*W, H, Color.salmon, "background", 1, 0, ""):paint(gc)

    Mat:paint(gc)
    
	gc:setColorRGB(unpack(Color.maroon))    


	Reset_Rectangle:paint(gc)
	--Clear/reset rectangle border
	gc:setColorRGB(unpack(Color.maroon))
	border((xmat - W/12 - W/10)/2, H - H/20, xmat - W/12 - W/10, H/10, "medium", 50, gc)
	
	Factors_Rectangle:paint(gc)
    --Factors Rectangle border
    gc:setColorRGB(unpack(Color.maroon))
    border(0.75*W - W/10, H - H/20, W/5, H/10, "medium", 50, gc)
	
    if showFactors == 1 then
	    factorsLabel = "(F)actors ON"
	    else
	    factorsLabel = "(F)actors OFF"	    
	end    

	Help_Rectangle:paint(gc)
        --Help Rectangle border
    gc:setColorRGB(unpack(Color.maroon))
    border(W/24, H - H/20, W/12, H/10, "medium", 50, gc)

	
	gc:setPen("thin", "smooth")

    TriangleD:paint(gc)
	TriangleU:paint(gc)
    TriangleD1:paint(gc)
	TriangleU1:paint(gc)
    

-- Now paint each of the objects in the Objects table

	for _, obj in ipairs(Objects) do
		obj:paint(gc)
	end

-- This checks whether the screen is small (HH) or large (computer) and adjusts display font size accordingly.

    	local fontSize = math.floor(W/32)
    	local fontSize = fontSize > 6 and fontSize or 6
    	local fontSize = fontSize <= 24 and fontSize or 24

        gc:setFont("serif", "r", fontSize)
        gc:setColorRGB(20,20,130)

	
-- We use Pretty to display the algebraic form as it is built	

		if x2value == 0 and xvalue == 0 and value == 0 then
        	local fontSize = math.floor(W/32)
           	local fontSize = math.floor(fontSize * 0.4)
	        local fontSize = fontSize > 6 and fontSize or 6
			gc:setFont("serif","r",fontSize)				
		    func = ""
		else
    	    local fontSize = math.floor(W/32)
   	        local fontSize = math.floor(fontSize * 1.5)
    	    local fontSize = fontSize > 6 and fontSize or 6
			gc:setFont("serif","r",fontSize)				
		    func = pretty(x2value.."x^2+"..xvalue.."x+"..value)        
		end
		
				
		local sw3 = gc:getStringWidth(func)
		gc:drawString(func,(xmat - sw3)/2,0.15*H)
		
        if factors and showFactors == 1 then
    	    local fontSize = math.floor(W/32)
   	        local fontSize = math.floor(fontSize * 1.2)
    	    local fontSize = fontSize > 7 and fontSize or 6
			gc:setFont("serif","r",fontSize)				
		    local sw4 = gc:getStringWidth(factors)
		    gc:drawString(factors,(xmat - sw4)/2,0.25*H)
        
        end
        
-- This displays the calculated value of the current expression

	local total = x2value*Xval^2+xvalue*Xval+value
	
	if x2value == 0 and xvalue == 0 and value == 0 then
        local fontSize = math.floor(W/32)
        local fontSize = math.floor(fontSize * 0.2)
	    local fontSize = fontSize > 6 and fontSize or 6
			gc:setFont("serif","i",fontSize)	
	    local str = "Drag tiles onto the mat"
	    local sw = gc:getStringWidth(str)
	    gc:drawString(str, (xmat - sw)/2, 0.075*H)
    else    	
        local fontSize = math.floor(W/32)
   	    local fontSize = math.floor(fontSize * 0.2)
	    local fontSize = fontSize > 6 and fontSize or 6
			gc:setFont("serif","r",fontSize)				
        local str = "When x = "..Xval.." then "..func.." = "..total
	    local sw = gc:getStringWidth(str)
	    gc:drawString(str, (xmat - sw)/2, 0.85*H)

    end
        local fontSize = math.floor(W/32)
   	    local fontSize = math.floor(fontSize * 0.2)
	    local fontSize = fontSize > 6 and fontSize or 6
			gc:setFont("serif","r",fontSize)				
            gc:drawString("x = "..Xval, 0.025*W, 0.5*H)

	if poscolour == negcolour then
		gc:setColorRGB(255,0,0)
		local str = "Make your tiles 2 different colours."
		local sw = gc:getStringWidth(str)
		gc:drawString(str,(xmat - sw)/2, 0.85*H)
	end

-- About Screen

    if About > 0 then
        aboutScreen(gc)
    end

end

--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------

-- SECTION 7: [Optional] Custom menu for Tile colours

function on.timer()
	if About==1 then
		About = 0
		timer.stop()
		platform.window:invalidate()
	end
end


function choosecolour(kind,clr)

		   if kind == "pos" then
                poscolour=clr
            else
                negcolour=clr
            end

  --[[  reset()]]
  
     for i = #Objects, 1, -1 do
		local obj = Objects[i]

        obj.color = obj.value > 0 and poscolour or negcolour 
     end

    platform.window:invalidate()
end

menu={

    {"Controls",

        {"Show/Hide Factors", function() on.charIn("f") end},
        {"Turn x or -x", function() Turn = Turn % 2 + 1 end},
        {"Reset", function() on.resize() end},
    },

    {"Select",

        {"Select x", function() on.charIn("x") end},
        {"Select -x", function() on.charIn("n") on.charIn("x") end},
        {"Select 1", function() on.charIn("u") end},
        {"Select -1", function() on.charIn("n") on.charIn("u")  end},
        {"Select x²", function() on.charIn("s") end},
        {"Select -x²", function() on.charIn("n")  on.charIn("s") end},
    },

    {"Positive Colour",

        {"Yellow", function() choosecolour("pos",Color.yellow) end},
        {"Red", function() choosecolour("pos",Color.red) end},
        {"Blue", function() choosecolour("pos",Color.blue) end},
        {"Black", function() choosecolour("pos",Color.black) end},
        {"Green", function() choosecolour("pos",Color.green) end},
        {"White", function() choosecolour("pos",Color.white) end},
        {"Pale Blue", function() choosecolour("pos",Color.paleblue) end},
        {"Navy", function() choosecolour("pos",Color.navy) end},
        {"Maroon", function() choosecolour("pos",Color.maroon) end},
        {"Gray", function() choosecolour("pos",Color.gray) end},
        {"Light Gray", function() choosecolour("pos",Color.lightgray) end},
        {"Salmon", function() choosecolour("pos",Color.salmon) end},
    },

    {"Negative Colour",

        {"Red", function() choosecolour("neg",Color.red) end},
        {"Yellow", function() choosecolour("neg",Color.yellow) end},
        {"Blue", function() choosecolour("neg",Color.blue) end},
        {"Black", function() choosecolour("neg",Color.black) end},
        {"Green", function() choosecolour("neg",Color.green) end},
        {"White", function() choosecolour("neg",Color.white) end},
        {"Pale Blue", function() choosecolour("neg",Color.paleblue) end},
        {"Navy", function() choosecolour("neg",Color.navy) end},
        {"Maroon", function() choosecolour("neg",Color.maroon) end},
        {"Gray", function() choosecolour("neg",Color.gray) end},
        {"Light Gray", function() choosecolour("neg",Color.lightgray) end},
        {"Salmon", function() choosecolour("neg",Color.salmon) end},
    },

    {"Help?",

		{"About", function() About=1 platform.window:invalidate() timer.start(4) end},   
    },

    }

toolpalette.register(menu)

-------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
