-- ************ BEGINS TI-Nspire Scripting - User Experience Example ************ --
--[[
    Copyright (C) 2012 Texas Instruments
    
    This script aims to show how to adapt optimize the control of movable objects for 
    both mouse and keyboard controls. In this way, the user experience is optimized for
    all TI-Nspire platforms.
    
    
    
        
    @author  Steve Arnold
    @date    2012/05/18
    
    @feedback  nspirescripting@list.ti.com
    @url       education.ti.com/nspire/scripting
    
    
    @history
    Date          Author          Comments          
    -----------------------------------------------
    2012-05-18    Steve.Arnold    Version 1.0
    2012-04-17    ARodriguez      Version 1.1
                                  Added back key
                                  Fixed how objects are created
                                  Tool palette is no longer possible to move
   
]]
--platform.apilevel = '2.0'  This technique is compatible with any version of nspire (and even any other systems)



-- *********** Begins Initialization section *************** --


Color = {
	red 		= {255, 0, 0},
	green		= {0, 255, 0},
	blue        = {0, 0, 255},
	lightblue        = {200, 200, 255},
	white        = {255, 255, 255}
}


--[[
    This is a init routine that runs only once. Paint routine is onPaint
]]
function on.paint(gc)

     
    -- Enable handlers
    on.paint  = onPaint
    on.resize = onResize
    
    -- Call initial onResize
    onResize(platform.window:width(), platform.window:height())


    -- Call initial onPaint
    onPaint(gc)
end

-- *********** Ends Initialization section *************** --



function onResize(w, h)

    Step = w/30
    Startx = 0.9*w
    StartCy = h/3
    StartRy = 2*h/3

    TrackedObject = nil
    TrackOffsetx = 0
    TrackOffsety = 0
    tabIndex = 1


    Canvas = Rectangle(w*0.4, h/2, w*0.8, h, Color.lightblue, "Canvas", "")
    Reset_Rectangle = Rectangle(w/10, h - w/50, w/5, w/10, Color.white, "Rectangle", "(R)eset")
    Objects = {
	    Circle(Startx, StartCy, w/10, w/10, Color.red, "Circle", ""),
	    Rectangle(Startx, StartRy, w/10, w/10, Color.green, "Rectangle", ""),
    }

    platform.window:invalidate()
    
    end


function onPaint(gc)

	gc:setColorRGB(200, 200, 200)

    Canvas:paint(gc)
    Reset_Rectangle:paint(gc)
    
	for _, obj in ipairs(Objects) do
		obj:paint(gc)
	end
	
	
end

-- *********** Set up the classes *************** --


Rectangle = class()

function Rectangle:init(x, y, w, h, color, type, label)
	self.x		= x
	self.y		= y
	self.w	= w or 20
	self.h	= h or 20
	self.color = color
	self.type = type
	self.selected = false
	self.label = label
	
	return self
end


function Rectangle:contains(x, y)
	local sw = self.w
	local sh = self.h
	return x >= self.x - sw/2 and x <= self.x + sw/2 and
	       y >= self.y - sh/2 and y <= self.y + sh/2
end


function Rectangle:paint(gc)
	gc:setColorRGB(unpack(self.color))
	gc:fillRect(self.x - self.w / 2, self.y - self.h / 2, self.w, self.h)
	gc:setPen("thin","smooth")
	gc:setColorRGB(0, 0, 0)
	gc:drawRect(self.x - self.w / 2, self.y - self.h / 2, self.w, self.h)
	if self.selected then
	gc:setPen("medium","smooth")
	gc:setColorRGB(0, 0, 0)
	gc:drawRect(self.x - self.w / 2, self.y - self.h / 2, self.w, self.h)
    end	
    local fontSize = platform.window:width()/32
    local fontSize = fontSize
	local fontSize = fontSize > 6 and fontSize or 6

    gc:setFont("sansserif", "r", fontSize)
	gc:setColorRGB(0, 0, 0)
    local sw = gc:getStringWidth(self.label)
    gc:drawString(self.label, self.w / 2 - sw/2, platform.window:height() - self.h / 4) 
end


Circle = class()

function Circle:init(x, y, w, h, color, type, label)
	self.x = x
	self.y = y
	self.w = w
	self.h = h
	self.radius = h/2
	self.color = color
	self.type = type
	self.selected = false
	self.label = label
	
	return self
end


function Circle:contains(x, y)
	local r = self.radius
	local d = math.sqrt((self.x - x)^2 + (self.y - y)^2)
	return d <= r
end

function Circle:paint(gc)
	local cx = self.x - self.radius
	local cy = self.y - self.radius
	local diameter = 2*self.radius
	gc:setColorRGB(unpack(self.color))
	gc:fillArc(cx, cy, diameter, diameter, 0, 360)
	if self.selected then
	    gc:setPen("medium","smooth")
	    gc:setColorRGB(0, 0, 0)
	gc:drawArc(cx, cy, diameter, diameter, 0, 360)
    end	

end


-- *********** Set up KeyBoard controls *************** --


function on.backtabKey()

           if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        tabIndex = tabIndex - 1
		        if tabIndex < 1  then
		            tabIndex = #Objects
		        end
		    end

  
   
	            TrackedObject = Objects[tabIndex]
	            
	       
 		    
			TrackedObject.selected = true
			platform.window:invalidate()
			
end

function on.tabKey()

           if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        tabIndex = tabIndex + 1
		        if tabIndex > #Objects then
		            tabIndex = 1
		        end
		    end

  
   
	            TrackedObject = Objects[tabIndex]
	            
	       
 		    
			TrackedObject.selected = true
			platform.window:invalidate()
			
end

function on.arrowRight()

    if TrackedObject ~= nil then
    
    	         obj = TrackedObject
		        TrackedObject.selected = false
		if TrackedObject.x == Startx then      
		if TrackedObject.y == StartCy or TrackedObject.y == StartRy then      
         obj = _G[obj.type](obj.x, obj.y, obj.w, obj.h, obj.color, obj.type, obj.label)
         table.insert(Objects, obj)
            TrackedObject = obj
			obj.selected = true
			
			TrackOffsetx = 0
			TrackOffsety = 0
			tabIndex = #Objects
          end
          end
    if TrackedObject.x < platform.window:width() - TrackedObject.w / 2 then
        TrackedObject.x = TrackedObject.x + Step
        end
    end
 platform.window:invalidate()
end

function on.arrowLeft()

	if TrackedObject ~= nil  then
   	         obj = TrackedObject
		        TrackedObject.selected = false
		if TrackedObject.x == Startx then      
 		if TrackedObject.y == StartCy or TrackedObject.y == StartRy then      
        obj = _G[obj.type](obj.x, obj.y, obj.w, obj.h, obj.color, obj.type, obj.label)
         table.insert(Objects, obj)
            TrackedObject = obj
			obj.selected = true
			
			TrackOffsetx = 0
			TrackOffsety = 0
			tabIndex = #Objects
          end
          end
    if TrackedObject.x > TrackedObject.w / 2 then
        TrackedObject.x = TrackedObject.x - Step
        end
    end
 platform.window:invalidate()
end


function on.arrowDown()

    if TrackedObject ~= nil then
   	         obj = TrackedObject
		        TrackedObject.selected = false
		if TrackedObject.x == Startx then      
 		if TrackedObject.y == StartCy or TrackedObject.y == StartRy then      
         obj = _G[obj.type](obj.x, obj.y, obj.w, obj.h, obj.color, obj.type, obj.label)
         table.insert(Objects, obj)
            TrackedObject = obj
			obj.selected = true
			
			TrackOffsetx = 0
			TrackOffsety = 0
			tabIndex = #Objects
          end
          end
    if TrackedObject.y < platform.window:height() - TrackedObject.h / 2 then
        TrackedObject.y = TrackedObject.y + Step
        end
    end
 platform.window:invalidate()
end

function on.arrowUp()

    if TrackedObject ~= nil then
   	         obj = TrackedObject
		        TrackedObject.selected = false
		if TrackedObject.x == Startx then      
 		if TrackedObject.y == StartCy or TrackedObject.y == StartRy then      
         obj = _G[obj.type](obj.x, obj.y, obj.w, obj.h, obj.color, obj.type, obj.label)
         table.insert(Objects, obj)
            TrackedObject = obj
			obj.selected = true
			
			TrackOffsetx = 0
			TrackOffsety = 0
			tabIndex = #Objects
          end
          end
    if TrackedObject.y > TrackedObject.h / 2 then
        TrackedObject.y = TrackedObject.y - Step
        end
    end
 platform.window:invalidate()
end

function on.enterKey()

        onResize(platform.window:width(), platform.window:height())

        if TrackedObject ~= nil then
            TrackedObject.selected= false
            TrackedObject = nil
            end
            platform.window:invalidate()
end

function on.escapeKey()
    
	    if TrackedObject ~= nil  then
	    
		  TrackedObject.selected = false
		  platform.window:invalidate()      
    end
end

function on.charIn(char)


    if char == "r" or char == "R" then
        on.resize(platform.window:width(), platform.window:height())
        platform.window:invalidate()
    end
end


-- *********** Set up Mouse controls *************** --


function on.mouseDown(x,y)
    
        if Reset_Rectangle:contains(x, y) then
		   Reset_Rectangle.selected = true
		   platform.window:invalidate()
        end

	for i = 1, #Objects do
	    local obj = Objects[i]
		if obj:contains(x, y) then

		    if TrackedObject ~= nil then
		        TrackedObject.selected = false
		        end
		    
			
			
		--if not Canvas.contains(x, y) then
		if i<=2 then
    			obj = _G[obj.type](obj.x, obj.y, obj.w, obj.h, obj.color, obj.type, obj.label)
			table.insert(Objects, obj)
		end
		--end
		
		    
		    TrackedObject = obj
			obj.selected = true
			tabIndex = #Objects
			
			TrackOffsetx = TrackedObject.x - x
			TrackOffsety = TrackedObject.y - y
			
			platform.window:invalidate()
			break
		end
	end

end


function on.mouseUp(x,y)

	if Reset_Rectangle.selected then
	    Reset_Rectangle.selected = false
	    	TrackedObject = nil

        on.resize(platform.window:width(), platform.window:height())

	end

		    if TrackedObject ~= nil then
		TrackedObject.x = x + TrackOffsetx
		TrackedObject.y = y + TrackOffsety

		        TrackedObject.selected = false
		       end    
    	TrackedObject = nil
    	

end


function on.mouseMove(x,y)
	if TrackedObject ~= nil  and tabIndex > 2 then
		TrackedObject.x = x + TrackOffsetx
		TrackedObject.y = y + TrackOffsety
		platform.window:invalidate()
	end
end




-- ************ ENDS TI-Nspire Scripting - User Experience Example ************ --


