platform.apilevel = "2.0"
-- So here is the quick and dirty way to get a ball bouncing around...
require "physics"
timer.start(0.01)


function on.resize()
   
   -- W and H are needed for playing with Position

   W = platform.window:width()
   H = platform.window:height()

    space = physics.Space()    
    newBody = physics.Body(100, 0)
    newBody:setVel(physics.Vect(1000,1000))
    
  -- Add a new starting position - bottom right corner?  
  --  newBody:setPos(physics.Vect(w,h)
  
    space:addBody(newBody)
end

function on.paint(gc)
    
    local width = w/10
    local vel = newBody:vel()
    local pos = newBody:pos()
	local velX = vel:x()
	local velY = vel:y()
	local posX = pos:x()
	local posY = pos:y()
 
    if posX > W - width then
        velX = -1 * math.abs(velX)
        posX = W - width -- Note the adjustment
    elseif posX < 0 then
        velX = math.abs(velX)
        posX = 0
    end

    if posY > H - width then
        velY = -1 * math.abs(velY)
        posY = H - width -- Note the adjustment
    elseif posY < 0 then
        velY = math.abs(velY)
        posY = 0
    end

    newBody:setPos(physics.Vect(posX, posY) )
    newBody:setVel(physics.Vect(velX, velY) )

      gc:setColorRGB(0, 0, 255)
      gc:fillArc(posX, posY, width, width, 0, 360)
   
   -- Here is a square instead of the circle
   -- gc:fillPolygon({ posX, posY, posX + width, posY, posX + width, posY + width, posX, posY + width}) 
end

function on.timer()
    space:step(0.01)
    platform.window:invalidate()
end
