platform.apilevel = "2.0"

require "physics"
require "color"
timer.start(0.01)

local W
local H
local space
local newBody
local newShape
local pos
local vel
local velX
local velY
local posX
local posY
local width
local gravity
local mass
local inertia
local elasticity
local friction


function init(gc)

    W = platform.window:width()
    H = platform.window:height()

    space = physics.Space()
    
    width = W/10
    gravity = 9.8
    elasticity = 1
    friction = 0

    space:setGravity(physics.Vect(0, gravity))
    mass = 100
    inertia = physics.misc.momentForCircle(mass, 0, width, physics.Vect(0,0))
    newBody = physics.Body(mass, inertia)
    newBody:setVel(physics.Vect(1000,1000))
    newBody:setPos(physics.Vect(0,0))
    newShape = physics.CircleShape(newBody, width, physics.Vect(0,width/2))
    newShape:setRestitution(elasticity)
    newShape:setFriction(friction)
    space:addBody(newBody)
    space:addShape(newShape)
    on.paint = paint
    paint(gc)
 
end

function paint(gc)
 
    pos = newBody:pos()
    vel = newBody:vel()
    velX = vel:x()
    velY = vel:y()
    posX = pos:x()
    posY = pos:y()
 
    if posX > W - width then
        velX = -1 * math.abs(velX)
        posX = W - width
    elseif posX < 0 then
        velX = math.abs(velX)
        posX = 0
    end

    if posY > H - width then
        velY = -1 * math.abs(velY)
        posY = H - width
    elseif posY < 0 then
        velY = math.abs(velY)
        posY = 0
    end

    newBody:setPos( physics.Vect(posX, posY) )
    newBody:setVel( physics.Vect(velX, velY) )

    -- Here is the blue square BUT it still thinks it is a circle!
    --gc:setColorRGB(color.blue)
    --gc:fillPolygon({posX, posY, posX + width, posY, posX + width, posY + width, posX, posY + width, posX, posY})

    -- Here is the orange circle
      gc:setColorRGB(color.orange)
      gc:fillArc(posX, posY, width, width, 0, 360)


end

function on.timer()

    space:step(0.01)
    platform.window:invalidate()

end

function on.resize()
    on.paint = init
end
