platform.apilevel = '2.0'
--[[

Chipmunk Hello World!
Copyright (C) 2012 Texas Instruments
 
Simple script to start the study of the Chipmunk engine in Nspire
 

Author: Alfredo Rodriguez
Date: 2011-07-25


Modification history
Date          User        Description
------------------------------------
July 9 2012    Steve Arnold    Simplified(?)

]]

    local W = platform.window:width()
    local H = platform.window:height()
    
    local totalBodies
    local newBody
    local newShape
    local bodies
    local shapes
    local radius
    local width
    local vertices
    local initX = 50
    local initY = 50
	local mass 
	local gravity
	local inertia
	local elasticity
	local friction
    local boundaries
    local bound
    local nspirepoints
    local shape
    local points 
    local point
    local velocity

	local im
	local play_image
	local pause_image
	local reset_image
	local play
	local pause
	
  --[[
    All physics animations need to initialize the physics enviroment
    before making use of the engine
  --]]
  
	require "physics"
	require "color"


function init(gc)

     W = platform.window:width()
     H = platform.window:height()

     totalBodies = var.recall("n") or 5
     nvertices = var.recall("sides") or 5
     velocity = var.recall("velocity") or velocity

     bodies = { }
     shapes = { }
     boundaries = {}
     nspirepoints = {}

     radius = W*0.075
     width = radius
	 mass = 100  
	 gravity = 0
	 elasticity = 1
	 friction = 0

	 
	 pause = 1
	 
 
	-- Create the space. All objects need a space in which to live
	space = physics.Space()


	-- By default the space has no gravity.
	space:setGravity(physics.Vect(0, gravity))
	
    -- Define our Polygon vertices
    local angleDelta = 360/nvertices
    local angle = 0
    vertices = { }
    for i=1,nvertices do
         table.insert(vertices, 1, physics.Vect(math.cos(math.rad(angle))*radius, math.sin(math.rad(angle))*radius))
         angle = angle + angleDelta
    end
    
    -- Set the attributes for the Polygons
    local inertia = physics.misc.momentForPoly(mass, vertices, physics.Vect(0,0))
    
    for i=1,totalBodies do
        newBody = physics.Body(mass, inertia)
        newShape = physics.PolyShape(newBody, vertices, physics.Vect(0,0))
        newShape:setRestitution(elasticity)
        newShape:setFriction(friction)
 
    -- Speed
        newBody:setVel(physics.Vect(velocity, velocity))
        
	-- Set object initial position in the space (by default is 0,0)
        newBody:setPos(physics.Vect(initX, initY))
        
        table.insert(bodies, newBody)
        table.insert(shapes, newShape)

	-- Add object to the space
        space:addBody(newBody)
        space:addShape(newShape)
    end
    
    -- Set up the control buttons
    border = Rectangle(0, H - 1.1*width, 2*width, 1.1*width)
    reset_button = Rectangle(0, H - width, width, width)
    go_button = Rectangle(width, H - width, width, width)

    -- Redirect future on.paint calls to our paint function
	on.paint = paint	
	paint(gc)

    -- Start timer
	timer.start(0.01)		


end

function bounds(w, h)
    
	-- Set the boundary walls

     for _,wall in ipairs(boundaries) do
        space:removeStaticShape(wall)
    end
    
    local bound

    bound = physics.SegmentShape(nil,  physics.Vect(0,0), physics.Vect(w, 0), 1)
                : setRestitution(elasticity)
                : setFriction(friction)
    space:addStaticShape(bound)
    table.insert(boundaries, bound)
    
    bound = physics.SegmentShape(nil,  physics.Vect(0,H), physics.Vect(w, h), 1)
                : setRestitution(elasticity)
                : setFriction(friction)
    space:addStaticShape(bound)
    table.insert(boundaries, bound)
    
    bound = physics.SegmentShape(nil,  physics.Vect(0,0), physics.Vect(0, h), 1)
                : setRestitution(elasticity)
                : setFriction(friction)
    space:addStaticShape(bound)
    table.insert(boundaries, bound)
    
    bound = physics.SegmentShape(nil,  physics.Vect(w,0), physics.Vect(w, h), 1)
                : setRestitution(elasticity)
                : setFriction(friction)
    space:addStaticShape(bound)
    table.insert(boundaries, bound)

end

function paint(gc)

    -- Set the boundaries
    
    bounds(W, H)
    
	-- Draw the objects  
	   
    for _,shape in ipairs(shapes) do -- Run through each of our shapes
        local pointcount = 1
        points = shape:points()
        for _,point in ipairs(points) do  -- Run through the points for each shape
            nspirepoints[pointcount] = point:x()  --Set each x position
            nspirepoints[pointcount] = nspirepoints[pointcount] < W and nspirepoints[pointcount] or W
            nspirepoints[pointcount] = nspirepoints[pointcount] > 0 and nspirepoints[pointcount] or 0
            
            nspirepoints[pointcount+1] = point:y()  --Set each y position
            nspirepoints[pointcount + 1] = nspirepoints[pointcount + 1] < H and nspirepoints[pointcount + 1] or H
            nspirepoints[pointcount + 1] = nspirepoints[pointcount + 1] > 0 and nspirepoints[pointcount + 1] or 0
            
            pointcount = pointcount + 2
        end
            gc:setColorRGB(math.random(255), math.random(255), math.random(255))
            gc:fillPolygon(nspirepoints)
            gc:setColorRGB(0)
            gc:drawPolyLine(nspirepoints)
    end

    -----------------------------------------
	-- Draw the button
	
    border:paint(gc)
    reset_button:paint(gc)
    go_button:paint(gc)
    
   if pause == 0 then
        im = image.copy(play_image, width, width) 
    else
        im = pause_image:copy(width, width)
    end
    
        imw, imh = im:width(), im:height()
        gc:drawImage(im, imw, H - imh)
        
        im1 = image.copy(reset_image, width, width)
        im1w, im1h = im1:width(), im1:height()
        gc:drawImage(im1, 0, H - im1h)
    

    
end


function on.timer()
	-- Ask the engine to produce the next step in time for the space
	space:step(pause*0.01)
	platform.window:invalidate()
end

----------------------------------------------------


function on.enterKey()
	-- Toggle the pause/go
    pause = 1 - pause
    platform.window:invalidate()
end

function on.escapeKey()
	-- Reset the action
    pause = 1 - pause
    on.resize()    
    platform.window:invalidate()    
end

function on.mouseUp(x, y)
	-- Reset the motion from wherever clicked (except for the button location)
	if go_button:contains(x, y) then
    	on.enterKey()
    elseif reset_button:contains(x, y) then
        on.escapeKey()
    else

    for k = 1, #shapes do
    initX = x
    initY = y
	        on.resize()
	end
    end
    platform.window:invalidate()    

end

function on.arrowUp()
	-- Add to the number of bodies
    totalBodies = (var.recall("n") or 5)
    if totalBodies < 20 then
        totalBodies = totalBodies + 1
        var.store("n", totalBodies)    
        on.resize()
    end
end


function on.arrowDown()
	-- Decrease the number of bodies
    totalBodies = (var.recall("n") or 5)
    if totalBodies > 1 then
        totalBodies = totalBodies - 1
        var.store("n", totalBodies)    
        on.resize()
    end
end

function on.backtabKey()
    -- Decrease velocity
     velocity = var.recall("velocity") or velocity

    if velocity >= 100 then
        velocity = velocity - 100
    end
    var.store("velocity", velocity)
    on.resize()
end

function on.tabKey()
    -- Increase velocity
     velocity = var.recall("velocity") or velocity
     velocity = velocity + 100
     var.store("velocity", velocity)
     on.resize()
end

function on.arrowRight()
	-- Increase the number of sides
    nvertices = var.recall("sides") or 5
    if nvertices < 20 then
        nvertices = nvertices + 1
        var.store("sides", nvertices)    
        on.resize()
    end
end

function on.arrowLeft()
	-- Decrease the number of sides
    nvertices = var.recall("sides") or 5
    if nvertices > 3 then
        nvertices = nvertices - 1
        var.store("sides", nvertices)    
        on.resize()
    end
end

----------------------------------------------------
-- After setting everything up, this runs the init function for the first time.


function on.resize()
	-- Start over
    on.paint = init
end


--------------------------------------------------------------------------- KeyPadKeyClass

Rectangle = class()

function Rectangle:init(x, y, width, height)
	self.x = x
	self.y = y
	self.width = width
	self.height = height
end

function Rectangle:contains(x, y)
	local sw = self.width
	local sh = self.height
	return x >= self.x and x <= self.x + sw and
    	   y >= self.y and y <= self.y + sh
end

function Rectangle:paint(gc)
	gc:setPen("medium", "smooth")
	gc:setColorRGB(color.black)
	gc:drawRect(self.x, self.y, self.width, self.height)

	gc:setColorRGB(color.gray)
	gc:fillRect(self.x, self.y, self.width, self.height)

end

play_image = image.new(";\000\000\000;\000\000\000\000\000\000\000v\000\000\000\016\000\001\000\255\127\255\127\255\127\255\127\189\247\165\148\181\214\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\181\214\165\148\189\247\255\127\255\127\255\127\255\127\255\127\255\127\255\127\255\127B\136\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128B\136\255\127\255\127\255\127\255\127\255\127\255\127\255\127\165\148\000\128B\136\206\185\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\206\185B\136\000\128\165\148\255\127\255\127\255\127\255\127\255\127\165\148\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247\165\148\000\128\165\148\255\127\255\127\189\247B\136\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247\165\148\000\128B\136\189\247\165\148\000\128B\136\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\254\251\254\251u\227u\227\234\198\234\198\166\186\166\186\132\182\132\182\132\182\132\182\166\186\166\186\234\198\234\198t\227t\227\253\251\253\251\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247B\136\000\128\165\148\181\214\000\128\206\185\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\254\251\254\251u\227u\227\234\198\234\198\166\186\166\186\132\182\132\182\132\182\132\182\166\186\166\186\234\198\234\198t\227t\227\253\251\253\251\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\206\185\000\128\181\214\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\220\247\220\247\014\207\014\207\131\178\131\178o\215o\215\216\243\216\243\251\247\251\247\252\251\252\251\252\251\252\251\251\247\251\247\216\243\216\243p\219p\219\164\182\164\182\014\207\014\207\219\243\219\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\220\247\220\247\014\207\014\207\131\178\131\178o\215o\215\216\243\216\243\251\247\251\247\252\251\252\251\252\251\252\251\251\247\251\247\216\243\216\243p\219p\219\164\182\164\182\014\207\014\207\219\243\219\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\2550\2150\215\131\178\131\178\181\231\181\231\252\251\252\251\251\251\251\251\250\247\250\247\249\247\249\247\249\247\249\247\249\247\249\247\249\247\249\247\250\247\250\247\251\251\251\251\252\251\252\251\181\235\181\235\131\178\131\178/\211/\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\2550\2150\215\131\178\131\178\181\231\181\231\252\251\252\251\251\251\251\251\250\247\250\247\249\247\249\247\249\247\249\247\249\247\249\247\249\247\249\247\250\247\250\247\251\251\251\251\252\251\252\251\181\235\181\235\131\178\131\178/\211/\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\013\207\013\207+\203+\203\251\247\251\247\250\247\250\247\248\243\248\243\247\243\247\243\246\239\246\239\245\239\245\239\245\239\245\239\245\239\245\239\245\239\245\239\246\239\246\239\247\243\247\243\248\243\248\243\250\247\250\247\251\251\251\251+\203+\203\013\207\013\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\013\207\013\207+\203+\203\251\247\251\247\250\247\250\247\248\243\248\243\247\243\247\243\246\239\246\239\245\239\245\239\245\239\245\239\245\239\245\239\245\239\245\239\246\239\246\239\247\243\247\243\248\243\248\243\250\247\250\247\251\251\251\251+\203+\203\013\207\013\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\010\203\010\203\250\247\250\247\215\243\215\243\213\239\213\239\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\213\239\213\239\215\243\215\243\250\247\250\247+\203+\203/\211/\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\010\203\010\203\250\247\250\247\215\243\215\243\213\239\213\239\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\212\235\213\239\213\239\215\243\215\243\250\247\250\247+\203+\203/\211/\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\220\247\220\247\163\178\163\178\216\243\216\243\213\235\213\235\179\231\179\231\178\231\178\231\178\231\178\231\145\227\145\227\009\199\009\199\130\174\130\174\010\203\010\203\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\179\231\179\231\213\235\213\235\216\243\216\243\163\178\163\178\187\243\187\243\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\220\247\220\247\163\178\163\178\216\243\216\243\213\235\213\235\179\231\179\231\178\231\178\231\178\231\178\231\145\227\145\227\009\199\009\199\130\174\130\174\010\203\010\203\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\178\231\179\231\179\231\213\235\213\235\216\243\216\243\163\178\163\178\187\243\187\243\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\014\207\014\207p\219p\219\180\235\180\235\178\227\178\227\177\227\177\227\177\227\177\227\177\227\177\227\008\199\008\1990\2150\215\219\247\219\247\165\182\165\182\231\194\231\194\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\178\227\178\227\180\235\180\235q\223q\223\013\207\013\207\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\014\207\014\207p\219p\219\180\235\180\235\178\227\178\227\177\227\177\227\177\227\177\227\177\227\177\227\008\199\008\1990\2150\215\219\247\219\247\165\182\165\182\231\194\231\194\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\177\227\178\227\178\227\180\235\180\235q\223q\223\013\207\013\207\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\253\251\253\251\130\178\130\178\180\231\180\231\144\227\144\227\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\231\194\231\1940\2150\215\255\255\255\255\254\255\254\255\234\198\234\198\230\190\230\190\142\219\142\219\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\144\227\144\227\180\231\180\231\130\178\130\178\253\251\253\251\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\253\251\253\251\130\178\130\178\180\231\180\231\144\227\144\227\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\231\194\231\1940\2150\215\255\255\255\255\254\255\254\255\234\198\234\198\230\190\230\190\142\219\142\219\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\143\223\144\227\144\227\180\231\180\231\130\178\130\178\253\251\253\251\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255R\219R\219\007\199\007\199k\211k\211\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\230\190\230\1900\2150\215\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\196\186\196\186*\207*\207\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219k\211k\211\007\195\007\195s\223s\223\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255R\219R\219\007\199\007\199k\211k\211\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\230\190\230\1900\2150\215\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\196\186\196\186*\207*\207\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219\142\219k\211k\211\007\195\007\195s\223s\223\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\234\198\234\198'\199'\199\034\195\034\195E\199E\199I\211I\211l\215l\215l\215l\215l\215l\215\229\190\229\1900\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255u\227u\227a\170a\170\007\199\007\199l\215l\215l\215l\215I\211I\211E\199E\199\034\195\034\195'\203'\203\233\194\233\194\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\234\198\234\198'\199'\199\034\195\034\195E\199E\199I\211I\211l\215l\215l\215l\215l\215l\215\229\190\229\1900\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255u\227u\227a\170a\170\007\199\007\199l\215l\215l\215l\215I\211I\211E\199E\199\034\195\034\195'\203'\203\233\194\233\194\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\165\182\165\182%\199%\199\001\191\001\191\001\187\001\187\034\191\034\191%\199%\199H\207H\207J\211J\211\196\186\196\1860\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\185\239\185\239\131\178\131\178\196\186\196\186%\199%\199\034\191\034\191\001\187\001\187\001\191\001\191%\199%\199\132\178\132\178\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\165\182\165\182%\199%\199\001\191\001\191\001\187\001\187\034\191\034\191%\199%\199H\207H\207J\211J\211\196\186\196\1860\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\185\239\185\239\131\178\131\178\196\186\196\186%\199%\199\034\191\034\191\001\187\001\187\001\191\001\191%\199%\199\132\178\132\178\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\131\178\131\178#\195#\195\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\001\191\001\191#\195#\195\194\182\194\1820\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\220\247\220\247\132\182\132\182\224\182\224\182\000\187\000\187\000\187\000\187\000\187\000\187#\195#\195a\174a\174\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\131\178\131\178#\195#\195\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\001\191\001\191#\195#\195\194\182\194\1820\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\220\247\220\247\132\182\132\182\224\182\224\182\000\187\000\187\000\187\000\187\000\187\000\187#\195#\195a\174a\174\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\130\174\130\174#\195#\195\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\160\178\160\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\253\251\253\251\164\182\164\182\224\182\224\182\000\187\000\187\000\187\000\187\000\187\000\187\034\195\034\195a\174a\174\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\130\174\130\174#\195#\195\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\160\178\160\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\253\251\253\251\164\182\164\182\224\182\224\182\000\187\000\187\000\187\000\187\000\187\000\187\034\195\034\195a\174a\174\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\165\182\165\182C\195C\195\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\160\178\160\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\186\243\186\243\132\178\132\178\160\178\160\178\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187B\195B\195\132\178\132\178\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\165\182\165\182C\195C\195\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187\160\178\160\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\186\243\186\243\132\178\132\178\160\178\160\178\000\187\000\187\000\187\000\187\000\187\000\187\000\187\000\187B\195B\195\132\178\132\178\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\234\194\234\194C\199C\199 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187\192\178\192\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\150\231\150\231a\170a\170\192\178\192\178 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187C\199C\199\233\194\233\194\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\234\194\234\194C\199C\199 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187\192\178\192\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\150\231\150\231a\170a\170\192\178\192\178 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187C\199C\199\233\194\233\194\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255R\219R\219#\195#\195 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187\192\178\192\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255Q\219Q\219`\170`\170\224\182\224\182 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187#\195#\195R\219R\219\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255R\219R\219#\195#\195 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187\192\178\192\1780\2150\215\255\255\255\255\255\255\255\255\255\255\255\255Q\219Q\219`\170`\170\224\182\224\182 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187 \187#\195#\195R\219R\219\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\221\251\221\251\128\174\128\174\130\199\130\199@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187\192\178\192\1780\2150\215\255\255\255\255\255\255\255\255\236\202\236\202\192\174\192\174 \183 \183@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187\130\199\130\199\160\174\160\174\220\247\220\247\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\221\251\221\251\128\174\128\174\130\199\130\199@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187\192\178\192\1780\2150\215\255\255\255\255\255\255\255\255\236\202\236\202\192\174\192\174 \183 \183@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187@\187\130\199\130\199\160\174\160\174\220\247\220\247\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\013\207\013\207c\199c\199`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187\192\178\192\1780\2150\215\253\251\253\251\199\190\199\190\192\174\192\174`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187c\199c\199\013\203\013\203\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\013\207\013\207c\199c\199`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187\192\178\192\1780\2150\215\253\251\253\251\199\190\199\190\192\174\192\174`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187`\187c\199c\199\013\203\013\203\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\219\243\219\243\128\174\128\174\196\207\196\207\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187`\183`\183`\170`\170`\170`\170\224\178\224\178\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\196\207\196\207\160\174\160\174\186\243\186\243\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\219\243\219\243\128\174\128\174\196\207\196\207\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187`\183`\183`\170`\170`\170`\170\224\178\224\178\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\128\187\196\207\196\207\160\174\160\174\186\243\186\243\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\001\187\001\187\196\211\196\211\160\191\160\191\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\196\207\196\207\001\187\001\187/\211/\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\001\187\001\187\196\211\196\211\160\191\160\191\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\160\187\196\207\196\207\001\187\001\187/\211/\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\013\207\013\207\001\187\001\187\229\215\229\215\226\199\226\199\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\226\199\226\199\229\215\229\215\001\187\001\187\013\207\013\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\013\207\013\207\001\187\001\187\229\215\229\215\226\199\226\199\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\192\187\226\199\226\199\229\215\229\215\001\187\001\187\013\207\013\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\128\174\128\174\163\203\163\203\229\215\229\215\227\207\227\207\225\199\225\199\225\195\225\195\224\191\224\191\224\191\224\191\225\195\225\195\225\199\225\199\227\207\227\207\229\215\229\215\163\203\163\203\128\174\128\174\014\211\014\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255/\211/\211\128\174\128\174\163\203\163\203\229\215\229\215\227\207\227\207\225\199\225\199\225\195\225\195\224\191\224\191\224\191\224\191\225\195\225\195\225\199\225\199\227\207\227\207\229\215\229\215\163\203\163\203\128\174\128\174\014\211\014\211\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\186\243\186\243\013\207\013\207\128\174\128\174B\191B\191\196\207\196\207\229\211\229\211\229\215\229\215\229\215\229\215\229\211\229\211\196\207\196\207b\195b\195\160\174\160\174\013\203\013\203\186\243\186\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\186\243\186\243\013\207\013\207\128\174\128\174B\191B\191\196\207\196\207\229\211\229\211\229\215\229\215\229\215\229\215\229\211\229\211\196\207\196\207b\195b\195\160\174\160\174\013\203\013\203\186\243\186\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\221\251\221\251s\223s\223\201\194\201\194\166\186\166\186a\174a\174a\174a\174\166\186\166\186\201\194\201\194S\223S\223\220\247\220\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\181\214\000\128\206\185\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\221\251\221\251s\223s\223\201\194\201\194\166\186\166\186a\174a\174a\174a\174\166\186\166\186\201\194\201\194S\223S\223\220\247\220\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\173\181\000\128\148\210\165\148\000\128B\136\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255Z\235\000\128\000\128B\136\189\247B\136\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255Z\235\000\128\000\128\000\128{\239\255\127\255\127\165\148\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255Z\235\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\165\148\000\128B\136\206\185\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\173\181\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\255\127\255\127B\136\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\255\127\255\127\255\127\189\247\165\148\181\214\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\148\210B\136{\239\255\127\255\127\255\127\255\127")
pause_image = image.new(";\000\000\000;\000\000\000\000\000\000\000v\000\000\000\016\000\001\000\255\127\255\127\255\127\255\127\189\247\165\148\181\214\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\181\214\165\148\189\247\255\127\255\127\255\127\255\127\255\127\255\127\255\127\255\127B\136\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128B\136\255\127\255\127\255\127\255\127\255\127\255\127\255\127\165\148\000\128B\136\206\185\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\206\185B\136\000\128\165\148\255\127\255\127\255\127\255\127\255\127\165\148\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247\165\148\000\128\165\148\255\127\255\127\189\247B\136\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247\165\148\000\128B\136\189\247\165\148\000\128B\136\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\092\215\092\215\185\170\185\170x\154x\154W\146W\146W\146W\146x\154x\154\185\170\185\170\092\211\092\211\223\247\223\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247B\136\000\128\165\148\181\214\000\128\206\185\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\092\215\092\215\185\170\185\170x\154x\154W\146W\146W\146W\146x\154x\154\185\170\185\170\092\211\092\211\223\247\223\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\206\185\000\128\181\214\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\222\243\222\243\250\186\250\186W\142W\142<\195<\195\223\235\223\235\255\247\255\247\255\251\255\251\255\251\255\251\255\247\255\247\223\235\223\235<\199<\199X\146X\146\250\186\250\186\190\239\190\239\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\222\243\222\243\250\186\250\186W\142W\142<\195<\195\223\235\223\235\255\247\255\247\255\251\255\251\255\251\255\251\255\247\255\247\223\235\223\235<\199<\199X\146X\146\250\186\250\186\190\239\190\239\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\027\195\027\195W\142W\142\158\223\158\223\255\255\255\255\255\243\255\243\223\231\223\231\191\227\191\227\191\227\191\227\191\227\191\227\191\227\191\227\223\231\223\231\255\243\255\243\255\251\255\251\158\227\158\227W\142W\142\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\027\195\027\195W\142W\142\158\223\158\223\255\255\255\255\255\243\255\243\223\231\223\231\191\227\191\227\191\227\191\227\191\227\191\227\191\227\191\227\223\231\223\231\255\243\255\243\255\251\255\251\158\227\158\227W\142W\142\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\250\182\250\182\251\178\251\178\255\251\255\251\223\235\223\235\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\223\235\223\235\255\251\255\251\251\178\251\178\250\182\250\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\250\182\250\182\251\178\251\178\255\251\255\251\223\235\223\235\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\223\235\223\235\255\251\255\251\251\178\251\178\250\182\250\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\218\174\218\174\223\247\223\247\159\219\159\219\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\219\159\219\223\247\223\247\251\182\251\182\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\218\174\218\174\223\247\223\247\159\219\159\219\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\219\159\219\223\247\223\247\251\182\251\182\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\222\243\222\243W\142W\142\223\239\223\239~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\207~\207~\207~\207~\211~\211~\211~\211~\207~\207~\211~\211~\211~\211\223\239\223\239W\142W\142\190\239\190\239\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\222\243\222\243W\142W\142\223\239\223\239~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\207~\207~\207~\207~\211~\211~\211~\211~\207~\207~\211~\211~\211~\211\223\239\223\239W\142W\142\190\239\190\239\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\186\250\186}\211}\211~\207~\207]\203]\203]\203]\203=\199=\199x\162x\162\212\133\212\133\212\133\212\133x\162x\162=\199=\199\027\187\027\187w\158w\158\212\133\212\133\244\133\244\133x\162x\162\028\191\028\191]\203]\203]\203]\203~\207~\207}\215}\215\250\182\250\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\186\250\186}\211}\211~\207~\207]\203]\203]\203]\203=\199=\199x\162x\162\212\133\212\133\212\133\212\133x\162x\162=\199=\199\027\187\027\187w\158w\158\212\133\212\133\244\133\244\133x\162x\162\028\191\028\191]\203]\203]\203]\203~\207~\207}\215}\215\250\182\250\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1427\142\158\223\158\223=\195=\195=\195=\195=\195=\195\152\162\152\162\250\194\250\194\255\255\255\255\255\255\255\255\250\194\250\194\152\162\152\162W\154W\154;\215;\215\255\255\255\255\255\255\255\255\027\207\027\207x\158x\158=\195=\195=\195=\195=\195=\195\158\223\158\2237\1427\142\223\247\223\247\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1427\142\158\223\158\223=\195=\195=\195=\195=\195=\195\152\162\152\162\250\194\250\194\255\255\255\255\255\255\255\255\250\194\250\194\152\162\152\162W\154W\154;\215;\215\255\255\255\255\255\255\255\255\027\207\027\207x\158x\158=\195=\195=\195=\195=\195=\195\158\223\158\2237\1427\142\223\247\223\247\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\251\182\251\182\252\170\252\170\028\187\028\187\028\187\028\187\028\187\028\1876\1506\150\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1506\150\021\138\021\138\190\239\190\239\255\255\255\255\255\255\255\255\189\235\189\235\021\142\021\142\028\187\028\187\028\187\028\187\028\187\028\187\251\170\251\170\218\178\218\178\092\207\092\207\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\251\182\251\182\252\170\252\170\028\187\028\187\028\187\028\187\028\187\028\1876\1506\150\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1506\150\021\138\021\138\190\239\190\239\255\255\255\255\255\255\255\255\189\235\189\235\021\142\021\142\028\187\028\187\028\187\028\187\028\187\028\187\251\170\251\170\218\178\218\178\092\207\092\207\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\251\186\251\186\154\142\154\142\187\158\187\158\251\174\251\174\252\178\252\1786\1466\146\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1466\146\245\137\245\137\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\021\142\021\142\252\178\252\178\251\174\251\174\187\158\187\158\154\142\154\142\028\191\028\191\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\251\186\251\186\154\142\154\142\187\158\187\158\251\174\251\174\252\178\252\1786\1466\146\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1466\146\245\137\245\137\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\021\142\021\142\252\178\252\178\251\174\251\174\187\158\187\158\154\142\154\142\028\191\028\191\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\251\174\251\174z\142z\142y\142y\142z\146z\146\154\154\154\1546\1426\142\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1426\142\245\137\245\137\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\021\138\021\138\154\154\154\154z\146z\146y\142y\142z\142z\142\219\174\219\174W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\251\174\251\174z\142z\142y\142y\142z\146z\146\154\154\154\1546\1426\142\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1426\142\245\137\245\137\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\021\138\021\138\154\154\154\154z\146z\146y\142y\142z\142z\142\219\174\219\174W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1427\142\186\162\186\162z\146z\146y\142y\142y\138y\138Y\138Y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\022\142\022\142\245\133\245\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133Y\138Y\138y\138y\138y\142y\142y\146y\146\186\162\186\1626\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1427\142\186\162\186\162z\146z\146y\142y\142y\138y\138Y\138Y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\022\142\022\142\245\133\245\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133Y\138Y\138y\138y\138y\142y\142y\146y\146\186\162\186\1626\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1387\138\186\162\186\162\154\150\154\150y\146y\146y\142y\142y\138y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\245\133\245\133\244\133\244\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133y\138y\138y\142y\142y\146y\146\154\150\154\150\186\158\186\1586\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1387\138\186\162\186\162\154\150\154\150y\146y\146y\142y\142y\138y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\245\133\245\133\244\133\244\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133y\138y\138y\142y\142y\146y\146\154\150\154\150\186\158\186\1586\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\186\162\186\162\186\158\186\158\154\150\154\150\154\146\154\146y\142y\142\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\134\021\134\244\133\244\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133y\142y\142\154\146\154\146\154\150\154\150\186\158\186\158\186\162\186\162W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\186\162\186\162\186\158\186\158\154\150\154\150\154\146\154\146y\142y\142\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\134\021\134\244\133\244\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133y\142y\142\154\146\154\146\154\150\154\150\186\158\186\158\186\162\186\162W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\218\170\218\170\219\166\219\166\186\158\186\158\186\154\186\154\154\150\154\150\022\134\022\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\134\021\134\244\133\244\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133\154\150\154\150\186\154\186\154\186\158\186\158\219\166\219\166\218\166\218\166\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\218\170\218\170\219\166\219\166\186\158\186\158\186\154\186\154\154\150\154\150\022\134\022\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\134\021\134\244\133\244\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133\154\150\154\150\186\154\186\154\186\158\186\158\219\166\219\166\218\166\218\166\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\186\166\186\166\251\178\251\178\219\170\219\170\219\162\219\162\187\158\187\158\022\138\022\138\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\022\134\022\134\245\133\245\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133\187\158\187\158\219\162\219\162\219\170\219\170\252\178\252\178\186\166\186\166<\203<\203\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\186\166\186\166\251\178\251\178\219\170\219\170\219\162\219\162\187\158\187\158\022\138\022\138\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\022\134\022\134\245\133\245\133\190\243\190\243\255\255\255\255\255\255\255\255\189\235\189\235\245\133\245\133\187\158\187\158\219\162\219\162\219\170\219\170\252\178\252\178\186\166\186\166<\203<\203\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1387\138\028\187\028\187\028\183\028\183\252\174\252\174\252\170\252\1707\1467\146;\207;\207\255\255\255\255\255\255\255\255;\207;\2077\1427\142\022\138\022\138|\231\158\223\255\255\255\255\255\255\255\255|\223|\2236\1426\142\252\170\252\170\252\174\252\174\028\183\028\183\028\187\028\1877\1427\142\223\243\223\243\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1387\138\028\187\028\187\028\183\028\183\252\174\252\174\252\170\252\1707\1467\146;\207;\207\255\255\255\255\255\255\255\255;\207;\2077\1427\142\022\138\022\138|\223|\231\255\255\255\255\255\255\255\255|\223|\2236\1426\142\252\170\252\170\252\174\252\174\028\183\028\183\028\187\028\1877\1427\142\223\243\223\243\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\182\250\182\219\170\219\170=\195=\195=\187=\187\028\183\028\183\219\170\219\170W\150W\150\212\133\212\133\212\133\212\133W\146W\146\186\158\186\158\153\154\153\154\022\142\022\142\212\133\212\133\212\133\212\1336\1426\142\186\162\186\162\028\183\028\183=\187=\187=\195=\195\219\174\219\174\218\182\218\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\182\250\182\219\170\219\170=\195=\195=\187=\187\028\183\028\183\219\170\219\170W\150W\150\212\133\212\133\212\133\212\133W\146W\146\186\158\186\158\153\154\153\154\022\142\022\142\212\133\212\133\212\133\212\1336\1426\142\186\162\186\162\028\183\028\183=\187=\187=\195=\195\219\174\219\174\218\182\218\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\190\239\190\2397\1387\138]\203]\203]\203]\203]\195]\195=\191=\191=\187=\187=\183=\183\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179=\183=\183=\187=\187=\191=\191]\195]\195]\203]\203]\203]\203W\142W\142\190\235\190\235\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\190\239\190\2397\1387\138]\203]\203]\203]\203]\195]\195=\191=\191=\187=\187=\183=\183\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179=\183=\183=\187=\187=\191=\191]\195]\195]\203]\203]\203]\203W\142W\142\190\235\190\235\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\153\158\153\158\158\215\158\215~\211~\211~\207~\207~\203~\203^\199^\199^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\199^\199~\203~\203~\207~\207~\211~\211\158\215\158\215\153\158\153\158\250\190\250\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\153\158\153\158\158\215\158\215~\211~\211~\207~\207~\203~\203^\199^\199^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\199^\199~\203~\203~\207~\207~\211~\211\158\215\158\215\153\158\153\158\250\190\250\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\218\182\218\182\153\158\153\158\159\215\159\215\159\219\159\219\159\215\159\215\159\215\159\215\159\211\159\211\159\211\159\211\159\207\159\207\159\207\159\207\159\211\159\211\159\211\159\211\159\215\159\215\159\215\159\215\159\219\159\219\159\219\159\219\186\162\186\162\218\182\218\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\218\182\218\182\153\158\153\158\159\215\159\215\159\219\159\219\159\215\159\215\159\215\159\215\159\211\159\211\159\211\159\211\159\207\159\207\159\207\159\207\159\211\159\211\159\211\159\211\159\215\159\215\159\215\159\215\159\219\159\219\159\219\159\219\186\162\186\162\218\182\218\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\1907\1387\138=\191=\191\191\223\191\223\191\223\191\223\191\223\191\223\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\223\191\223\191\223\191\223\191\223\191\223=\191=\1917\1387\138\250\186\250\186\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\1907\1387\138=\191=\191\191\223\191\223\191\223\191\223\191\223\191\223\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\223\191\223\191\223\191\223\191\223\191\223=\191=\1917\1387\138\250\186\250\186\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\190\235\190\235\218\182\218\1827\1387\138\251\174\251\174~\207~\207\159\211\159\211\191\223\191\223\191\223\191\223\159\211\159\211~\207~\207\251\174\251\174W\142W\142\218\182\218\182\190\235\190\235\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\190\235\190\235\218\182\218\1827\1387\138\251\174\251\174~\207~\207\159\211\159\211\191\223\191\223\191\223\191\223\159\211\159\211~\207~\207\251\174\251\174W\142W\142\218\182\218\182\190\235\190\235\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\247\223\247\092\207\092\207\153\166\153\166x\154x\1546\1346\1346\1346\134x\154x\154\153\166\153\166<\207<\207\223\243\223\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\181\214\000\128\206\185\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\247\223\247\092\207\092\207\153\166\153\166x\154x\1546\1346\1346\1346\134x\154x\154\153\166\153\166<\207<\207\223\243\223\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\206\185\000\128s\206\165\148\000\128B\136\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255|\231\000\128\000\128B\136\189\247B\136\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255|\231\000\128\000\128\000\128\157\235\255\127\255\127\165\148\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255|\231\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\165\148\000\128B\136\206\185\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\206\185\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\255\127\255\127B\136\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\255\127\255\127\255\127\189\247\165\148\181\214\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218s\206B\136\157\235\255\127\255\127\255\127\255\127")
reset_image = image.new(";\000\000\000;\000\000\000\000\000\000\000v\000\000\000\016\000\001\000\255\127\255\127\255\127\255\127\189\247\165\148\181\214\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\181\214\165\148\189\247\255\127\255\127\255\127\255\127\255\127\255\127\255\127\255\127B\136\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128B\136\255\127\255\127\255\127\255\127\255\127\255\127\255\127\165\148\000\128B\136\206\185\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\016\194\206\185B\136\000\128\165\148\255\127\255\127\255\127\255\127\255\127\165\148\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247\165\148\000\128\165\148\255\127\255\127\189\247B\136\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247\165\148\000\128B\136\189\247\165\148\000\128B\136\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\092\215\092\215\185\170\185\170x\154x\154W\146W\146W\146W\146x\154x\154\185\170\185\170\092\211\092\211\223\247\223\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\189\247B\136\000\128\165\148\181\214\000\128\206\185\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\092\215\092\215\185\170\185\170x\154x\154W\146W\146W\146W\146x\154x\154\185\170\185\170\092\211\092\211\223\247\223\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\206\185\000\128\181\214\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\222\243\222\243\250\186\250\186W\142W\142<\195<\195\223\235\223\235\255\247\255\247\255\251\255\251\255\251\255\251\255\247\255\247\223\235\223\235<\199<\199X\146X\146\250\186\250\186\190\239\190\239\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\222\243\222\243\250\186\250\186W\142W\142<\195<\195\223\235\223\235\255\247\255\247\255\251\255\251\255\251\255\251\255\247\255\247\223\235\223\235<\199<\199X\146X\146\250\186\250\186\190\239\190\239\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\027\195\027\195W\142W\142\158\223\158\223\255\255\255\255\255\243\255\243\223\231\223\231\191\227\191\227\191\227\191\227\191\227\191\227\191\227\191\227\223\231\223\231\255\243\255\243\255\251\255\251\158\227\158\227W\142W\142\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\027\195\027\195W\142W\142\158\223\158\223\255\255\255\255\255\243\255\243\223\231\223\231\191\227\191\227\191\227\191\227\191\227\191\227\191\227\191\227\223\231\223\231\255\243\255\243\255\251\255\251\158\227\158\227W\142W\142\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\250\182\250\182\251\178\251\178\255\251\255\251\223\235\223\235\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\223\235\223\235\255\251\255\251\251\178\251\178\250\182\250\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\250\182\250\182\251\178\251\178\255\251\255\251\223\235\223\235\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\223\235\223\235\255\251\255\251\251\178\251\178\250\182\250\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\218\174\218\174\223\247\223\247\159\219\159\219\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\219\159\219\223\247\223\247\251\182\251\182\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\218\174\218\174\223\247\223\247\159\219\159\219\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\215\159\219\159\219\223\247\223\247\251\182\251\182\251\190\251\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\222\243\222\243W\142W\142\223\239\223\239~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\207~\207~\207~\207=\199=\199\153\170\153\170\185\174\185\174~\207~\207~\211~\211\223\239\223\239W\142W\142\190\239\190\239\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\222\243\222\243W\142W\142\223\239\223\239~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\211~\211~\211~\211~\207~\207~\211~\211~\207~\207~\207~\207=\199=\199\153\170\153\170\185\174\185\174~\207~\207~\211~\211\223\239\223\239W\142W\142\190\239\190\239\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\186\250\186}\211}\211~\207~\207]\203]\203]\203]\203=\199=\199x\162x\162\212\133\212\133\212\133\212\133x\162x\162=\199=\199]\203]\203]\203]\203\218\174\218\1745\1505\150\250\198\250\198\217\186\217\186x\162x\162]\203]\203~\207~\207}\215}\215\250\182\250\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\186\250\186}\211}\211~\207~\207]\203]\203]\203]\203=\199=\199x\162x\162\212\133\212\133\212\133\212\133x\162x\162=\199=\199]\203]\203]\203]\203\218\174\218\1745\1505\150\250\198\250\198\217\186\217\186x\162x\162]\203]\203~\207~\207}\215}\215\250\182\250\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1427\142\158\223\158\223=\195=\195=\195=\195=\195=\195\152\162\152\162\250\194\250\194\255\255\255\255\255\255\255\255\250\194\250\194\152\162\152\162=\195=\195\185\170\185\1705\1465\146\157\231\157\231\255\255\255\255\255\255\255\255\212\133\212\133=\195=\195=\195=\195\158\223\158\2237\1427\142\223\247\223\247\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1427\142\158\223\158\223=\195=\195=\195=\195=\195=\195\152\162\152\162\250\194\250\194\255\255\255\255\255\255\255\255\250\194\250\194\152\162\152\162=\195=\195\185\170\185\1705\1465\146\157\231\157\231\255\255\255\255\255\255\255\255\212\133\212\133=\195=\195=\195=\195\158\223\158\2237\1427\142\223\247\223\247\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\251\182\251\182\252\170\252\170\028\187\028\187\028\187\028\187\028\187\028\1876\1506\150\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1506\150\185\166\185\166\021\146\021\146\157\231\157\231\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\028\187\028\187\028\187\028\187\251\170\251\170\218\178\218\178\092\207\092\207\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\251\182\251\182\252\170\252\170\028\187\028\187\028\187\028\187\028\187\028\1876\1506\150\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1506\150\185\166\185\166\021\146\021\146\157\231\157\231\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\028\187\028\187\028\187\028\187\251\170\251\170\218\178\218\178\092\207\092\207\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\251\186\251\186\154\142\154\142\187\158\187\158\251\174\251\174\252\178\252\1786\1466\146\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1466\146\021\146\021\146\157\231\157\231\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\251\174\251\174\187\158\187\158\154\142\154\142\028\191\028\191\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\251\186\251\186\154\142\154\142\187\158\187\158\251\174\251\174\252\178\252\1786\1466\146\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\2196\1466\146\021\146\021\146\157\231\157\231\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\251\174\251\174\187\158\187\158\154\142\154\142\028\191\028\191\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\251\174\251\174z\142z\142y\142y\142z\146z\146\154\154\154\1546\1426\142\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\142\021\142\157\231\157\231\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133z\146z\146y\142y\142z\142z\142\219\174\219\174W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\251\174\251\174z\142z\142y\142y\142z\146z\146\154\154\154\1546\1426\142\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\142\021\142\157\231\157\231\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133z\146z\146y\142y\142z\142z\142\219\174\219\174W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1427\142\186\162\186\162y\146y\146y\142y\142y\138y\138Y\138Y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219|\231\158\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133y\138y\138y\142y\142y\146y\146\186\162\186\1626\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1427\142\186\162\186\162y\146y\146y\142y\142y\138y\138Y\138Y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\158\223|\231\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133y\138y\138y\142y\142y\146y\146\186\162\186\1626\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1387\138\186\162\186\162\154\150\154\150y\146y\146y\142y\142y\138y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219;\215;\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133y\142y\142y\146y\146\154\150\154\150\186\158\186\1586\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\2557\1387\138\186\162\186\162\154\150\154\150y\146y\146y\142y\142y\138y\138\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219;\215;\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133y\142y\142y\146y\146\154\150\154\150\186\158\186\1586\1346\134\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\186\162\186\162\186\158\186\158\154\150\154\150\154\146\154\146y\142y\142\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\244\133\244\133\092\215\092\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\154\146\154\146\154\150\154\150\186\158\186\158\186\162\186\162W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255X\150X\150\186\162\186\162\186\158\186\158\154\150\154\150\154\146\154\146y\142y\142\021\134\021\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\244\133\244\133\092\215\092\215\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\154\146\154\146\154\150\154\150\186\158\186\158\186\162\186\162W\146W\146\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\218\170\218\170\219\166\219\166\186\158\186\158\186\154\186\154\154\150\154\150\022\134\022\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\134\021\134\244\137\244\137\092\215\092\215\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\186\154\186\154\186\158\186\158\219\166\219\166\218\166\218\166\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\185\170\185\170\218\170\218\170\219\166\219\166\186\158\186\158\186\154\186\154\154\150\154\150\022\134\022\134\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\021\134\021\134\244\137\244\137\092\215\092\215\255\255\255\255\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\186\154\186\154\186\158\186\158\219\166\219\166\218\166\218\166\185\166\185\166\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\186\166\186\166\251\178\251\178\219\170\219\170\219\162\219\162\187\158\187\158\022\138\022\138\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\022\134\022\134X\142X\142\244\137\244\137\092\215\092\215\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\219\162\219\162\219\170\219\170\252\178\252\178\186\166\186\166<\203<\203\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255<\203<\203\186\166\186\166\251\178\251\178\219\170\219\170\219\162\219\162\187\158\187\158\022\138\022\138\092\219\092\219\255\255\255\255\255\255\255\255\092\219\092\219\022\134\022\134X\142X\142\244\137\244\137\092\215\092\215\255\255\255\255\255\255\255\255\255\251\255\251\244\133\244\133\219\162\219\162\219\170\219\170\252\178\252\178\186\166\186\166<\203<\203\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1387\138\028\187\028\187\028\183\028\183\252\174\252\174\252\170\252\1707\1467\146;\207;\207\255\255\255\255\255\255\255\255;\207;\2077\1427\142\187\154\187\154y\146y\146\244\137\244\137\092\215\092\215\255\255\255\255\255\255\255\255\244\133\244\133\252\174\252\174\028\183\028\183\028\187\028\1877\1427\142\223\243\223\243\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\223\247\223\2477\1387\138\028\187\028\187\028\183\028\183\252\174\252\174\252\170\252\1707\1467\146;\207;\207\255\255\255\255\255\255\255\255;\207;\2077\1427\142\187\154\187\154y\146y\146\244\137\244\137\092\215\092\215\255\255\255\255\255\255\255\255\244\133\244\133\252\174\252\174\028\183\028\183\028\187\028\1877\1427\142\223\243\223\243\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\182\250\182\219\170\219\170=\195=\195=\187=\187\028\183\028\183\219\170\219\170W\150W\150\212\133\212\133\212\133\212\133W\146W\146\186\158\186\158\220\162\220\162\220\166\220\166\186\158\186\1587\1467\146\212\133\212\133\244\133\244\133w\154w\154=\187=\187=\195=\195\219\174\219\174\218\182\218\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\250\182\250\182\219\170\219\170=\195=\195=\187=\187\028\183\028\183\219\170\219\170W\150W\150\212\133\212\133\212\133\212\133W\146W\146\186\158\186\158\220\162\220\162\220\166\220\166\186\158\186\1587\1467\146\212\133\212\133\244\133\244\133w\154w\154=\187=\187=\195=\195\219\174\219\174\218\182\218\182\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\190\239\190\2397\1387\138]\203]\203]\203]\203]\195]\195=\191=\191=\187=\187=\183=\183\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179=\183=\183=\187=\187=\191=\191]\195]\195]\203]\203]\203]\203W\142W\142\190\235\190\235\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\190\239\190\2397\1387\138]\203]\203]\203]\203]\195]\195=\191=\191=\187=\187=\183=\183\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179\029\179=\183=\183=\187=\187=\191=\191]\195]\195]\203]\203]\203]\203W\142W\142\190\235\190\235\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\153\158\153\158\158\215\158\215~\211~\211~\207~\207~\203~\203^\199^\199^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\199^\199~\203~\203~\207~\207~\211~\211\158\215\158\215\153\158\153\158\250\190\250\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\190\153\158\153\158\158\215\158\215~\211~\211~\207~\207~\203~\203^\199^\199^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\195^\199^\199~\203~\203~\207~\207~\211~\211\158\215\158\215\153\158\153\158\250\190\250\190\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\218\182\218\182\153\158\153\158\159\215\159\215\159\219\159\219\159\215\159\215\159\215\159\215\159\211\159\211\159\211\159\211\159\207\159\207\159\207\159\207\159\211\159\211\159\211\159\211\159\215\159\215\159\215\159\215\159\219\159\219\159\219\159\219\186\162\186\162\218\182\218\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\218\182\218\182\153\158\153\158\159\215\159\215\159\219\159\219\159\215\159\215\159\215\159\215\159\211\159\211\159\211\159\211\159\207\159\207\159\207\159\207\159\211\159\211\159\211\159\211\159\215\159\215\159\215\159\215\159\219\159\219\159\219\159\219\186\162\186\162\218\182\218\182\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\1907\1387\138=\191=\191\191\223\191\223\191\223\191\223\191\223\191\223\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\223\191\223\191\223\191\223\191\223\191\223=\191=\1917\1387\138\250\186\250\186\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\190\251\1907\1387\138=\191=\191\191\223\191\223\191\223\191\223\191\223\191\223\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\219\191\223\191\223\191\223\191\223\191\223\191\223=\191=\1917\1387\138\250\186\250\186\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\190\235\190\235\218\182\218\1827\1387\138\251\174\251\174~\207~\207\159\211\159\211\191\223\191\223\191\223\191\223\159\211\159\211~\207~\207\251\174\251\174W\142W\142\218\182\218\182\190\235\190\235\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\190\235\190\235\218\182\218\1827\1387\138\251\174\251\174~\207~\207\159\211\159\211\191\223\191\223\191\223\191\223\159\211\159\211~\207~\207\251\174\251\174W\142W\142\218\182\218\182\190\235\190\235\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\214\218\000\128\016\194\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\247\223\247\092\207\092\207\153\166\153\166x\154x\1546\1346\1346\1346\134x\154x\154\153\166\153\166<\207<\207\223\243\223\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\239\189\000\128\214\218\181\214\000\128\206\185\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\247\223\247\092\207\092\207\153\166\153\166x\154x\1546\1346\1346\1346\134x\154x\154\153\166\153\166<\207<\207\223\243\223\243\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\206\185\000\128s\206\165\148\000\128B\136\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255|\231\000\128\000\128B\136\189\247B\136\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255|\231\000\128\000\128\000\128|\231\255\127\255\127\165\148\000\128\165\148\189\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255|\231\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\165\148\000\128B\136\206\185\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\239\189\206\185\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\255\127\255\127B\136\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\128\255\255\255\127\255\127\255\127\255\127\255\127\255\127\255\127\189\247\165\148\181\214\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218\214\218s\206B\136\157\231\255\127\255\127\255\127\255\127")


