--Graphics Tutorial 1
--Steve Arnold August 30 2011

    h=platform.window:height() 
    w=platform.window:width() 
    x = (var.recall("px") or 0)
    y = (var.recall("py") or 0)
    xt = (var.recall("xtick") or 10)
    yt = (var.recall("ytick") or 10)

-- This sets up a screen refresh to occur 10 times per second.
	function on.timer()
	    platform.window:invalidate()
	end


	function on.create()
    	timer.start(1/10)
	end

                     
function on.arrowUp()

    var.store("py", y-yt)
    platform.window:invalidate()
end

function on.arrowDown()

    var.store("py", y+yt)
    platform.window:invalidate()
end

function on.arrowLeft()

    var.store("px", x-xt)
    platform.window:invalidate()
end

function on.arrowRight()

    var.store("px", x+xt)
    platform.window:invalidate()
end

function on.enterKey()
    local x = (var.recall("px") or 0)
    local y = (var.recall("py") or 0)
     if x == 160 and y == 100 then
     local sc = (var.recall("scale") or 1)
     var.store("scale",sc + 1)
     else
	var.store("px",160)
	var.store("py",100)
	end
	platform.window:invalidate()

end

function on.escapeKey()
     local sc = (var.recall("scale") or 1)
     var.store("scale",sc - 1)
	platform.window:invalidate()

end

--

function drawBox(x, y, length, height, scaler, gc) 
    
	gc:drawRect(x, y, scaler*height, scaler*height/2)

end

function on.paint(gc)

    local scaler = (var.recall("scale") or 1)
    w = platform.window:width()
    h = platform.window:height()
    x = (var.recall("px") or w/2)
    y = (var.recall("py") or h/2)
    str = "Drag point P"
    
	gc:setPen("medium", "smooth")
	
	gc:setColorRGB(255,165,0)
	gc:fillArc(x, y, scaler*h/4, scaler*h/4, 0, 360)
	gc:fillArc(x + scaler*h/4, y, scaler*h/4, scaler*h/4, 0, 360)
	drawBox(x, y, h/2, h/2, scaler, gc)

	gc:setColorRGB(165,42,42)
	gc:fillArc(x - scaler*h/4, y, scaler*h/4, scaler*h/4, 0, 360)
	gc:fillArc(x - scaler*h/2, y, scaler*h/4, scaler*h/4, 0, 360)
	drawBox(x - scaler*h/2, y, h/2, h/2, scaler, gc)
	
	gc:setFont("sansserif", "i", 10)
    gc:setColorRGB(20, 20, 138)
    strwidth = gc:getStringWidth(str)
    gc:drawString(str,x - strwidth/2, y - 10)
	
end
