-- Shape Numbers Explorer
-- Steve Arnold August 31 2011

 --This sets up a screen refresh to occur 5 times per second (needed for the handheld). 
 function on.timer() 
     platform.window:invalidate() 
 end 

 function on.create() 
   timer.start(1/5) 
 end 

-------------------------------------------------------------------------------------


function on.arrowLeft()

        ch = (var.recall("type") or 1)
    if ch > 1 then
        var.store("type", ch - 1)
        else
        var.store("type", 1)
    end    

end

function on.arrowRight()

        ch = (var.recall("type") or 1)
    if ch < 3 then
        var.store("type", ch + 1)
        else
        var.store("type", 3)
    end    

end

function on.arrowUp()

        num = (var.recall("n") or 1)
    if num > 1 and num < 100 then
        var.store("n", num + 1)
        else
        var.store("n", num)
    end    

end

function on.arrowDown()

        num = (var.recall("n") or 1)
    if num > 1 and num < 100 then
        var.store("n", num - 1)
        else
        var.store("n", num)
    end    

end

function on.tabKey()
        num = (var.recall("n") or 1)
        tabnum = (var.recall("tab") or 1)
    if tabnum > -1 and tabnum < num - 1 then
        var.store("tab", tabnum + 1)
        else
        var.store("tab", 0)
    end    

end

function on.escapeKey()
        num = (var.recall("n") or 1)
        tabnum = (var.recall("tab") or 1)
    if tabnum > -1 and tabnum < num - 1 then
        var.store("tab", tabnum - 1)
        else
        var.store("tab", 0)
    end    
end

function on.enterKey()
     shw = (var.recall("view") or 0)
     
     if shw > -1 and shw < 2 then
         var.store("view",shw + 1)
     else
         var.store("view",0)
     end
end

function counter(tabnum)
     local w = platform.window:width()
     local h = platform.window:height()
     local types = (var.recall("type") or 1)
     local num = (var.recall("n") or 1) 
     local xval = math.floor(w/(num+4))
     local yval = math.floor(h/(num+4))
     local x = w/2 - (num)*(xval)/2
     local y = h/2 - (num)*(yval)/2
     platform.gc():setPen("thin", "smooth")     
     if types == 1 then
        if tabnum == 0 then
                       platform.gc():setColorRGB(20, 20, 138)
                        platform.gc():fillArc(x, y, xval, yval, 0, 360)
        else
 
                 for k = 0, tabnum do
                        platform.gc():setColorRGB((20+25*k) % 255, (20+25*k) % 255, (138-25*k) % 255)
                    for m = 0, tabnum do
                        platform.gc():fillArc(x + (xval)*(m), y + (yval)*(k), xval, yval, 0, 360)
                    end
                end
        end
        elseif types == 2 then
        
            if tabnum == 0 then
                        platform.gc():setColorRGB(20, 20, 138)
                        platform.gc():fillArc(x, y, xval, yval, 0, 360)
                        platform.gc():fillArc(x + xval, y, xval, yval, 0, 360)
        else
 
            for k = 1, tabnum + 1 do
                        platform.gc():setColorRGB((20+25*k) % 255, (20+25*k) % 255, (138-25*k) % 255)
                for m = 0, tabnum + 1 do
                        platform.gc():fillArc(x + (xval)*(m), y + yval*(k-1), xval, yval, 0, 360)
                end
            end
        end


        else
            for k = 0, tabnum do
                     platform.gc():setColorRGB((20+25*k) % 255, (20+25*k) % 255, (138-25*k) % 255)
                for m = k, tabnum do
                     platform.gc():fillArc(x + (xval)*(m), y + yval*(k), xval, yval, 0, 360)
                end
            end
        end
end

function drawArray(number, x, y, length, height)
     types = (var.recall("type") or 1)
     shw = (var.recall("view") or 1)
    
    if types == 1 then
        if shw ==1 then
            platform.gc():drawRect(x, y, (length)*(number+1) - length, height*(number))
                for k = 1, number do
                    for m = 1, number do
                        platform.gc():drawArc(x + (length)*(m-1), y + (height)*(k-1), length, height, 0, 360)
                    end
                end
        elseif shw == 2 then
       
             for k = 0, number do
                 for m = 0, number do
         
                   platform.gc():drawLine(x, y + (height)*(m), x + (length)*(number), y + (height)*(m))
                   platform.gc():drawLine(x + (length)*(k), y, x + (length)*(k), y + height*(number))
         
                 end
             end    
       
        else
            for k = 1, number do
                for m = 1, number do
                    platform.gc():drawArc(x + (length)*(m-1), y + (height)*(k-1), length, height, 0, 360)
                end
            end
        end
    elseif types == 2 then
        if shw ==1 then
            platform.gc():drawRect(x, y, length*(number+1), height*(number))    
            for k = 1, number do
                for m = 0, number do
                    platform.gc():drawArc(x + (length)*(m), y + height*(k-1), length, height, 0, 360)
                end
            end
        elseif shw == 2 then
            for k = 0, number+1 do
                 for m = 0, number do
         
                   platform.gc():drawLine(x, y + (height)*(m), x + (length)*(number+1), y + (height)*(m))
                   platform.gc():drawLine(x + (length)*(k), y, x + (length)*(k), y + height*(number))
         
                 end
             end    

        else
            for k = 2, number+1 do
                for m = 1, number+1 do
                    platform.gc():drawArc(x + (length)*(m-1), y + height*(k-2), length, height, 0, 360)
                end
            end
        end
    else

        if shw == 1 then
            platform.gc():drawPolyLine({x - 0.7*length, y, x + (number)*length, y, x + (number)*length, y + (number+1)*height - height/5, x - 0.7*length, y})
            for k = 1, number do
                for m = k, number do
                    platform.gc():drawArc(x + length*(m-1), y + height*(k-1), length, height, 0, 360)
                end
            end
        elseif shw == 2 then
            platform.gc():drawLine(x, y, x + (length)*(number+1) - length, y )         
            platform.gc():drawLine(x + (length)*(number), y, x + (length)*(number), y + height*(number))
       
             for k = 1, number do
                 for m = k, number do
                 
                  platform.gc():drawLine(x + length*(m-1), y + (height)*(m), x + (length)*(number), y + (height)*(m))
                  platform.gc():drawLine(x + (length)*(m-1), y, x + (length)*(m-1), y + height*(m))
          
                 end
             end    
       
        else
             for k = 1, number do
                for m = k, number do
                     platform.gc():drawArc(x + length*(m-1), y + height*(k-1), length, height, 0, 360)
               end
            end
        end
     end
end

 
function on.paint(gc)

     w = platform.window:width()
     h = platform.window:height()
     num = (var.recall("n") or 1)
     types = (var.recall("type") or 1)
     tabnum = (var.recall("tab") or 0)
     
     if tabnum > -1 and tabnum < num then
         counter(tabnum)
     end
     
    xval = math.floor(w/(num+4))
    yval = math.floor(h/(num+4))
    x = w/2 - (num)*(xval)/2
    y = h/2 - (num)*(yval)/2

    gc:setColorRGB(165,42,42)
    gc:setPen("thin", "smooth")
    
    drawArray(num, x, y, xval, yval)

    gc:setFont("sansserif", "b", 8)
    gc:setColorRGB(20, 20, 138)
    
    if types == 1 then
        str1 = "Square Numbers"
        str2 = num.."×"..num.." = "..num^2
            str3 = "1"
    for k = 2, tabnum + 1 do
          str3 = str3.."+"..2*k - 1
          end
    --str3 = str3.." = "..num^2
    elseif types == 2 then
       str1 = "Rectangular Numbers"
        str2 = num.."×"..(num+1).." = "..num*(num+1)
            str3 = "2"
    for k = 2, tabnum + 1 do
          str3 = str3.."+"..2*k
          end
    --str3 = str3.." = "..num*(num+1)
    else
       str1 = "Triangular Numbers"
        str2 = "("..num.."×"..(num+1)..")/2 = "..num*(num+1)/2
            str3 = "1"
    for k = 2, tabnum + 1 do
          str3 = str3.."+"..k
          end
    --str3 = str3.." = "..num*(num+1)/2

    end
    strwidth = gc:getStringWidth(str1..": "..str2)
    gc:drawString(str1..": "..str2, (w - strwidth)/2 , 0, "top")
    
    
   strwidth = gc:getStringWidth(str3)
   gc:drawString(str3, (w - strwidth)/2 , h-5, "bottom")


end

